package it.inaf.ia2.gms.controller;

import it.inaf.ia2.gms.authn.SessionData;
import it.inaf.ia2.gms.model.request.GroupsRequest;
import it.inaf.ia2.gms.model.response.GroupsTabResponse;
import it.inaf.ia2.gms.model.response.HomePageResponse;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class HomePageController {

    @Autowired
    private SessionData session;

    @Autowired
    private GroupsTabResponseBuilder groupsTabResponseBuilder;

    @ResponseBody
    @GetMapping(value = "/home", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    public ResponseEntity<HomePageResponse> getMainPage(@Valid GroupsRequest request) {

        HomePageResponse response = new HomePageResponse();

        response.setUser(session.getUserId());

        GroupsTabResponse groupsTabResponse = groupsTabResponseBuilder.getGroupsTab(request);
        response.setBreadcrumbs(groupsTabResponse.getBreadcrumbs());
        response.setGroupsPanel(groupsTabResponse.getGroupsPanel());
        response.setPermission(groupsTabResponse.getPermission());

        return ResponseEntity.ok(response);
    }

    @GetMapping(value = "/", produces = MediaType.TEXT_HTML_VALUE)
    public String index() {
        return "index.html";
    }
}
