package it.inaf.ia2.gms.authn;

import it.inaf.ia2.aa.data.User;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.annotation.SessionScope;

@Component
@SessionScope
public class SessionData {

    private static final String USER_DATA = "user_data";

    @Autowired
    private HttpServletRequest request;

    private String userId;
    private String userName;
    private String accessToken;
    private String refreshToken;
    private long expiration;

    @PostConstruct
    public void init() {

        HttpSession session = request.getSession(false);
        if (session != null && session.getAttribute(USER_DATA) != null) {
            User user = (User) session.getAttribute(USER_DATA);
            userId = user.getName();
            userName = user.getUserLabel();
            accessToken = user.getAccessToken();
            refreshToken = user.getRefreshToken();
            setExpiresIn(user.getExpiresIn());
        }
    }

    public String getUserId() {
        return userId;
    }

    public String getAccessToken() {
        return accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getRefreshToken() {
        return refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getUserName() {
        return userName;
    }

    public void setExpiresIn(long expiresIn) {
        this.expiration = System.currentTimeMillis() + expiresIn * 1000;
    }

    public long getExpiresIn() {
        return (expiration - System.currentTimeMillis()) / 1000;
    }
}
