package it.inaf.ia2.gms.model;

import static org.junit.Assert.assertEquals;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(JUnit4.class)
public class PermissionTest {

    @Test
    public void addPermissionTest() {

        // Old = null
        assertEquals(Permission.ADMIN, Permission.addPermission(null, Permission.ADMIN));
        assertEquals(Permission.MANAGE_MEMBERS, Permission.addPermission(null, Permission.MANAGE_MEMBERS));
        assertEquals(Permission.VIEW_MEMBERS, Permission.addPermission(null, Permission.VIEW_MEMBERS));
        assertEquals(Permission.TRAVERSE, Permission.addPermission(null, Permission.TRAVERSE));

        // Old = ADMIN -> never change
        assertEquals(Permission.ADMIN, Permission.addPermission(Permission.ADMIN, Permission.VIEW_MEMBERS));
        assertEquals(Permission.ADMIN, Permission.addPermission(Permission.ADMIN, Permission.MANAGE_MEMBERS));
        assertEquals(Permission.ADMIN, Permission.addPermission(Permission.ADMIN, Permission.TRAVERSE));

        // Old = MANAGE_MEMBERS
        assertEquals(Permission.ADMIN, Permission.addPermission(Permission.MANAGE_MEMBERS, Permission.ADMIN));
        assertEquals(Permission.MANAGE_MEMBERS, Permission.addPermission(Permission.MANAGE_MEMBERS, Permission.VIEW_MEMBERS));
        assertEquals(Permission.MANAGE_MEMBERS, Permission.addPermission(Permission.MANAGE_MEMBERS, Permission.TRAVERSE));

        // Old = VIEW_MEMBERS
        assertEquals(Permission.ADMIN, Permission.addPermission(Permission.VIEW_MEMBERS, Permission.ADMIN));
        assertEquals(Permission.MANAGE_MEMBERS, Permission.addPermission(Permission.VIEW_MEMBERS, Permission.MANAGE_MEMBERS));
        assertEquals(Permission.VIEW_MEMBERS, Permission.addPermission(Permission.VIEW_MEMBERS, Permission.TRAVERSE));

        // Old = TRAVERSE
        assertEquals(Permission.ADMIN, Permission.addPermission(Permission.TRAVERSE, Permission.ADMIN));
        assertEquals(Permission.MANAGE_MEMBERS, Permission.addPermission(Permission.TRAVERSE, Permission.MANAGE_MEMBERS));
        assertEquals(Permission.VIEW_MEMBERS, Permission.addPermission(Permission.TRAVERSE, Permission.VIEW_MEMBERS));
    }
}
