package it.inaf.ia2.gms.service;

import it.inaf.ia2.gms.exception.UnauthorizedException;
import it.inaf.ia2.gms.model.Permission;
import it.inaf.ia2.gms.model.RapUser;
import it.inaf.ia2.gms.persistence.MembershipsDAO;
import it.inaf.ia2.gms.persistence.model.GroupEntity;
import it.inaf.ia2.gms.persistence.model.MembershipEntity;
import it.inaf.ia2.gms.rap.RapClient;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MembersService {

    @Autowired
    private MembershipsDAO membershipsDAO;

    @Autowired
    private PermissionsService permissionsService;

    @Autowired
    private RapClient rapClient;

    public List<RapUser> getMembers(String groupId) {

        List<MembershipEntity> memberships = membershipsDAO.findByGroup(groupId);

        Set<String> userIdentifiers = memberships.stream()
                .map(m -> m.getUserId())
                .collect(Collectors.toSet());

        return rapClient.getUsers(userIdentifiers);
    }

    public MembershipEntity addMember(String groupId, String userId) {

        MembershipEntity membership = new MembershipEntity();
        membership.setGroupId(groupId);
        membership.setUserId(userId);

        return membershipsDAO.addMember(membership);
    }

    public void removeMember(String groupId, String userId) {
        membershipsDAO.removeMembership(groupId, userId);
    }
    
    public Permission verifyUserCanManageMembers(GroupEntity group, String userId) {
        Permission currentNodePermission = permissionsService.getUserPermissionForGroup(group, userId);
        if (currentNodePermission != Permission.ADMIN && currentNodePermission != Permission.MANAGE_MEMBERS) {
            throw new UnauthorizedException("Missing admin or manage members permissions");
        }
        return currentNodePermission;
    }
}
