package it.inaf.ia2.gms.controller;

import it.inaf.ia2.gms.persistence.GroupsDAO;
import it.inaf.ia2.gms.persistence.MembershipsDAO;
import it.inaf.ia2.gms.persistence.model.GroupEntity;
import java.security.Principal;
import java.util.Optional;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import static org.mockito.ArgumentMatchers.anyString;
import static org.mockito.ArgumentMatchers.eq;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import static org.mockito.Mockito.when;
import org.mockito.junit.MockitoJUnitRunner;
import org.springframework.test.web.servlet.MockMvc;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

@RunWith(MockitoJUnitRunner.class)
public class JWTWebServiceControllerTest {

    @Mock
    private MembershipsDAO membershipsDAO;

    @Mock
    private GroupsDAO groupsDAO;

    @InjectMocks
    private JWTWebServiceController controller;

    private final Principal principal = new Principal() {
        @Override
        public String getName() {
            return "TEST_PRINCIPAL";
        }
    };

    private MockMvc mockMvc;

    @Before
    public void init() {
        mockMvc = MockMvcBuilders.standaloneSetup(controller).build();
    }

    @Test
    public void testIsMemberOf() throws Exception {

        GroupEntity group1 = new GroupEntity();
        group1.setId("1");
        group1.setPath("1");
        group1.setName("group.1");

        GroupEntity group2 = new GroupEntity();
        group2.setId("2");
        group2.setPath("1.2");
        group2.setName("subgroup");

        GroupEntity group3 = new GroupEntity();
        group3.setId("3");
        group3.setPath("1.2.3");
        group3.setName("subsubgroup");

        when(groupsDAO.findGroupByParentAndName(eq(""), eq("group.1")))
                .thenReturn(Optional.of(group1));
        when(groupsDAO.findGroupByParentAndName(eq("1"), eq("subgroup")))
                .thenReturn(Optional.of(group2));
        when(groupsDAO.findGroupByParentAndName(eq("1.2"), eq("subsubgroup")))
                .thenReturn(Optional.of(group3));

        when(membershipsDAO.isMemberOf(anyString(), eq(group3.getId()))).thenReturn(true);

        String group = "group\\.1.subgroup.subsubgroup";

        mockMvc.perform(get("/ws/jwt/search/" + group).principal(principal))
                .andExpect(status().isOk())
                .andExpect(content().string(group + "\n"));
    }
}
