package it.inaf.ia2.gms;

import it.inaf.ia2.aa.AuthConfig;
import it.inaf.ia2.aa.ServiceLocator;
import it.inaf.ia2.aa.UriCustomizer;
import it.inaf.ia2.aa.jwt.QueryStringBuilder;
import static it.inaf.ia2.gms.authn.ClientDbFilter.CLIENT_DB;
import it.inaf.ia2.gms.exception.BadRequestException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@SpringBootApplication
@Configuration
@EnableTransactionManagement
public class GmsApplication {

    public static void main(String[] args) {
        SpringApplication.run(GmsApplication.class, args);

        AuthConfig authConfig = ServiceLocator.getInstance().getConfig();

        final String defaultAuthorizationUri = authConfig.getUserAuthorizationUri();

        authConfig.setAuthorizationUriCustomizer(new UriCustomizer() {

            @Override
            public String getBaseUri(HttpServletRequest req) {
                // for a better security we should check for allowed redirects
                String redirect = req.getParameter("redirect");
                if (redirect != null) {
                    return redirect;
                }
                return defaultAuthorizationUri;
            }

            @Override
            public void customizeQueryString(HttpServletRequest req, QueryStringBuilder queryStringBuilder) {
                String clientDb = req.getParameter(CLIENT_DB);
                if (clientDb == null) {
                    HttpSession session = req.getSession(false);
                    if (session != null) {
                        clientDb = (String) session.getAttribute(CLIENT_DB);
                    }
                }
                if (clientDb == null) {
                    throw new BadRequestException("client_db not set");
                }
                queryStringBuilder.param(CLIENT_DB, clientDb);
            }
        });

        final String defaultAccessTokenUri = authConfig.getAccessTokenUri();

        authConfig.setAccessTokenUriCustomizer(req -> {
            String redirect = req.getParameter("token_uri");
            if (redirect != null) {
                return redirect;
            }
            return defaultAccessTokenUri;
        });
    }
}
