package it.inaf.ia2.gms.authn;

import it.inaf.ia2.aa.ServiceLocator;
import it.inaf.ia2.aa.jwt.JwksClient;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ClientDbFilter implements Filter {

    public static final String CLIENT_DB = "client_db";

    private String defaultJwksUri;
    private JwksClient jwksClient;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        defaultJwksUri = ServiceLocator.getInstance().getConfig().getJwksUri();
        jwksClient = ServiceLocator.getInstance().getJwksClient();
    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain fc) throws IOException, ServletException {

        HttpServletRequest request = (HttpServletRequest) req;
        HttpServletResponse response = (HttpServletResponse) res;

        String clientDb = request.getParameter(CLIENT_DB);
        if (clientDb != null) {
            request.getSession().setAttribute(CLIENT_DB, clientDb);
            String newUrl = defaultJwksUri.replaceAll("\\?client_name=(.*)", "?client_name=" + clientDb);
            jwksClient.addJwksUrl(newUrl);
        }

        fc.doFilter(req, res);
    }
}
