package it.inaf.ia2.gms.authn;

import java.util.Collection;
import java.util.Map;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;

public class CustomAuthenticationData extends UsernamePasswordAuthenticationToken {

    private final Map<String, Object> attributes;
    private final OAuth2AccessToken accessToken;
    private final OAuth2RefreshToken refreshToken;

    public CustomAuthenticationData(String username, Map<String, Object> attributes,
            Collection<? extends GrantedAuthority> authorities,
            OAuth2AccessToken accessToken, OAuth2RefreshToken refreshToken) {
        super(username, "N/A", authorities);
        this.attributes = attributes;
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
    }

    public Map<String, Object> getAttributes() {
        return attributes;
    }

    public OAuth2AccessToken getAccessToken() {
        return accessToken;
    }

    public OAuth2RefreshToken getRefreshToken() {
        return refreshToken;
    }
}
