package it.inaf.ia2.gms.service;

import it.inaf.ia2.gms.model.Permission;
import it.inaf.ia2.gms.persistence.model.GroupEntity;
import it.inaf.ia2.gms.persistence.model.PermissionEntity;
import java.util.List;
import java.util.Optional;

public class PermissionUtils {

    public static Optional<Permission> getGroupPermission(GroupEntity group, List<PermissionEntity> permissions) {

        Permission groupPermission = null;

        for (PermissionEntity permission : permissions) {

            boolean directPermission = permission.getGroupId().equals(group.getId());
            boolean permissionInChildGroup = permission.getGroupPath().startsWith(group.getPath());
            boolean permissionInParentGroup = group.getPath().startsWith(permission.getGroupPath());

            if (directPermission || permissionInChildGroup || permissionInParentGroup) {

                if (permissionInChildGroup) {
                    // Traversal only
                    groupPermission = Permission.addPermission(groupPermission, Permission.TRAVERSE);
                } else {
                    // Direct permission or permission inherited from parent
                    groupPermission = Permission.addPermission(groupPermission, permission.getPermission());
                }
            }

            if (groupPermission == Permission.ADMIN) {
                // reached the maximum permission
                break;
            }
        }

        return Optional.ofNullable(groupPermission);
    }
}
