package it.inaf.ia2.gms.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GroupNode {

    private String groupId;
    private String groupName;
    private Set<Permission> permissions;
    private boolean hasChildren;

    public GroupNode() {
        permissions = new HashSet<>();
    }

    @JsonProperty("id")
    public String getGroupId() {
        return groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @JsonProperty("name")
    public String getGroupName() {
        return groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public List<Permission> getPermissions() {
        return Collections.unmodifiableList(new ArrayList<>(permissions));
    }

    public void setPermissions(Set<Permission> permissions) {
        this.permissions = permissions;
    }

    public void addPermission(Permission permission) {

        // remove implied permissions
        switch (permission) {
            case ADMIN:
                permissions.add(permission);
                permissions.remove(Permission.MANAGE_MEMBERS);
                permissions.remove(Permission.VIEW_MEMBERS);
                permissions.remove(Permission.TRAVERSE);
                break;
            case MANAGE_MEMBERS:
                if (!permissions.contains(Permission.ADMIN)) {
                    permissions.add(permission);
                    permissions.remove(Permission.VIEW_MEMBERS);
                    permissions.remove(Permission.TRAVERSE);
                }
                break;
            case VIEW_MEMBERS:
                if (!permissions.contains(Permission.ADMIN)
                        && !permissions.contains(Permission.MANAGE_MEMBERS)) {
                    permissions.add(permission);
                    permissions.remove(Permission.TRAVERSE);
                }
                break;
            case TRAVERSE:
                if (permissions.isEmpty()) {
                    permissions.add(permission);
                }
                break;
        }
    }

    public boolean isHasChildren() {
        return hasChildren;
    }

    public void setHasChildren(boolean hasChildren) {
        this.hasChildren = hasChildren;
    }
}
