package it.inaf.ia2.gms.persistence.model;

import java.io.Serializable;
import java.util.Objects;

public class MembershipId implements Serializable {

    String _user;
    String _group;

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + Objects.hashCode(this._user);
        hash = 47 * hash + Objects.hashCode(this._group);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final MembershipId other = (MembershipId) obj;
        if (!Objects.equals(this._user, other._user)) {
            return false;
        }
        if (!Objects.equals(this._group, other._group)) {
            return false;
        }
        return true;
    }
}
