package it.inaf.ia2.gms.persistence;

import it.inaf.ia2.gms.model.Permission;
import it.inaf.ia2.gms.persistence.model.UserPermission;
import java.sql.PreparedStatement;
import java.sql.Types;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class PermissionsDAO {

    private final JdbcTemplate jdbcTemplate;

    @Autowired
    public PermissionsDAO(DataSource dataSource) {
        jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public UserPermission createPermission(UserPermission userPermission) {

        String sql = "INSERT INTO gms_permission(group_id, user_id, permission) VALUES(?, ?, ?)";

        jdbcTemplate.update(conn -> {
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setString(1, userPermission.getGroupId());
            ps.setString(2, userPermission.getUserId());
            ps.setObject(3, userPermission.getPermission().toString(), Types.OTHER);
            return ps;
        });

        return userPermission;
    }

    public List<UserPermission> findUserPermissions(String userId) {

        String sql = "SELECT group_id, permission FROM gms_permission WHERE user_id = ?";

        return jdbcTemplate.query(conn -> {
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setString(1, userId);
            return ps;
        }, resultSet -> {
            List<UserPermission> permissions = new ArrayList<>();
            while (resultSet.next()) {
                UserPermission permission = new UserPermission();
                permission.setGroupId(resultSet.getString("group_id"));
                permission.setUserId(userId);
                permission.setPermission(Permission.valueOf(resultSet.getString("permission")));
                permissions.add(permission);
            }
            return permissions;
        });
    }

    public void deletePermission(UserPermission userPermission) {

        String sql = "DELETE FROM gms_permission WHERE group_id = ? AND user_id = ? AND permission = ?";

        jdbcTemplate.update(conn -> {
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setString(1, userPermission.getGroupId());
            ps.setString(2, userPermission.getUserId());
            ps.setObject(3, userPermission.getPermission().toString(), Types.OTHER);
            return ps;
        });
    }
}
