package it.inaf.ia2.gms.persistence.model;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

/**
 * Note: if necessary this class could contain also a role (specific for the
 * application using the GMS). Currently that is not implemented.
 */
@Entity
@IdClass(MembershipId.class)
@Table(name = "gms_membership")
public class Membership {

    @Id
    @ManyToOne
    @JoinColumn(name = "user_id", referencedColumnName = "id", columnDefinition = "varchar(50)")
    private User _user;

    @Id
    @ManyToOne
    @JoinColumn(name = "group_id", referencedColumnName = "id", columnDefinition = "varchar(50)")
    private Group _group;

    public User getUser() {
        return _user;
    }

    public void setUser(User _user) {
        this._user = _user;
    }

    public Group getGroup() {
        return _group;
    }

    public void setGroup(Group _group) {
        this._group = _group;
    }
}
