package it.inaf.ia2.gms.service;

import it.inaf.ia2.gms.model.GroupBreadcrumb;
import it.inaf.ia2.gms.model.GroupNode;
import it.inaf.ia2.gms.model.GroupsModelRequest;
import it.inaf.ia2.gms.model.GroupsModelResponse;
import it.inaf.ia2.gms.model.PaginatedData;
import it.inaf.ia2.gms.model.Permission;
import it.inaf.ia2.gms.model.RapUser;
import it.inaf.ia2.gms.model.UserPermission;
import it.inaf.ia2.gms.persistence.model.Group;
import it.inaf.ia2.gms.persistence.model.User;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GroupsModelService {

    @Autowired
    private UsersService usersService;

    @Autowired
    private GroupsService groupsService;

    @Autowired
    private MembersService membersService;

    @Autowired
    private PermissionsService permissionsService;

    public GroupsModelResponse getGroupsModel(GroupsModelRequest request, String userId) {

        User user = usersService.getUserById(userId);
        Group group = groupsService.getGroupById(request.getGroupId());

        GroupsModelResponse response = new GroupsModelResponse();

        response.setPage("groups");

        response.setBreadcrumbs(buildBreadcrumbs(new ArrayList<>(), group));

        List<Permission> currentNodePermissions = groupsService.getPermissions(group, user);
        response.setPermissions(currentNodePermissions);

        switch (request.getTab()) {
            case "groups":
                List<GroupNode> groupNodes = groupsService.getSubgroups(group, user);
                response.setGroupsPanel(new PaginatedData<>(groupNodes, request.getPaginatorPage(), request.getPaginatorPageSize()));
                break;
            case "members":
                if (currentNodePermissions.contains(Permission.ADMIN)
                        || currentNodePermissions.contains(Permission.MANAGE_MEMBERS)
                        || currentNodePermissions.contains(Permission.VIEW_MEMBERS)) {
                    List<RapUser> members = membersService.getMembers(group);
                    response.setMembersPanel(new PaginatedData<>(members, request.getPaginatorPage(), request.getPaginatorPageSize()));
                }
                break;
            case "permissions":
                if (currentNodePermissions.contains(Permission.ADMIN)) {
                    List<UserPermission> permissions = permissionsService.getUserPermissions(group);
                    response.setPermissionsPanel(new PaginatedData<>(permissions, request.getPaginatorPage(), request.getPaginatorPageSize()));
                }
                break;
        }

        return response;
    }

    private List<GroupBreadcrumb> buildBreadcrumbs(List<GroupBreadcrumb> breadcrumbs, Group group) {

        GroupBreadcrumb bc = new GroupBreadcrumb();
        bc.setGroupId(group.getId());
        bc.setGroupName(group.getName());
        breadcrumbs.add(bc);

        if (group.getParentGroup() == null) {
            Collections.reverse(breadcrumbs);
            return breadcrumbs;
        } else {
            return buildBreadcrumbs(breadcrumbs, group.getParentGroup());
        }
    }
}
