package it.inaf.ia2.gms.service;

import it.inaf.ia2.gms.model.RapUser;
import it.inaf.ia2.gms.persistence.MembershipRepository;
import it.inaf.ia2.gms.persistence.model.Group;
import it.inaf.ia2.gms.persistence.model.Membership;
import it.inaf.ia2.gms.rap.RapClient;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MembersService {

    @Autowired
    private MembershipRepository membershipRepository;

    @Autowired
    private RapClient rapClient;

    public List<RapUser> getMembers(Group group) {
        List<Membership> memberships = membershipRepository.findBy_group(group);

        Set<String> userIdentifiers = memberships.stream()
                .map(m -> m.getUser().getId())
                .collect(Collectors.toSet());

        return rapClient.getUsers(userIdentifiers);
    }
}
