package it.inaf.ia2.gms.service;

import it.inaf.ia2.gms.exception.BadRequestException;
import it.inaf.ia2.gms.model.Permission;
import it.inaf.ia2.gms.model.RapUser;
import it.inaf.ia2.gms.model.UserPermission;
import it.inaf.ia2.gms.persistence.PermissionsRepository;
import it.inaf.ia2.gms.persistence.model.Group;
import it.inaf.ia2.gms.persistence.model.UserGroupPermission;
import it.inaf.ia2.gms.rap.RapClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PermissionsService {

    private final PermissionsRepository permissionsRepository;
    private final RapClient rapClient;

    @Autowired
    public PermissionsService(PermissionsRepository permissionsRepository, RapClient rapClient) {
        this.permissionsRepository = permissionsRepository;
        this.rapClient = rapClient;
    }

    public List<UserPermission> getUserPermissions(Group group) {

        List<UserGroupPermission> permissions = permissionsRepository.findBy_group(group);

        Set<String> userIdentifiers = permissions.stream()
                .map(p -> p.getUser().getId())
                .collect(Collectors.toSet());

        Map<String, RapUser> users = rapClient.getUsers(userIdentifiers).stream()
                .collect(Collectors.toMap(RapUser::getId, Function.identity()));

        List<UserPermission> result = new ArrayList<>();

        for (UserGroupPermission p : permissions) {
            RapUser rapUser = users.get(p.getUser().getId());
            if (rapUser != null) {
                UserPermission permission = new UserPermission();
                permission.setPermission(p.getPermission());
                permission.setUser(rapUser);
                result.add(permission);
            }
        }

        return result;
    }

    public void deletePermission(String userId, String groupId, Permission permission) {

        UserGroupPermission ugp = permissionsRepository.findPermission(userId, groupId, permission)
                .orElseThrow(() -> new BadRequestException("Permission not found (UserId="
                + userId + ", GroupId=" + groupId + ", Permission=" + permission + ")"));

        permissionsRepository.delete(ugp);
    }
}
