package it.inaf.ia2.gms.authn;

import it.inaf.ia2.aa.LoginFilter;
import java.io.IOException;
import java.util.Arrays;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.AntPathMatcher;

public class GmsLoginFilter extends LoginFilter {

    @Override
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain fc) throws IOException, ServletException {

        HttpServletRequest request = (HttpServletRequest) req;

        if (shouldNotFilter(request)) {
            fc.doFilter(req, res);
        } else {
            super.doFilter(req, res, fc);
        }
    }

    private boolean shouldNotFilter(HttpServletRequest request) throws ServletException {

        // Allow CORS check
        if ("OPTIONS".equals(request.getMethod())) {
            return true;
        }

        AntPathMatcher pathMatcher = new AntPathMatcher();

        // Authentication is ignored for these endpoints:
        return Arrays.asList("/ws/jwt/**", "/error", "/logout", "/invited-registration", "/help/**")
                .stream()
                .anyMatch(p -> pathMatcher.match(p, request.getServletPath()));
    }
}
