package it.inaf.ia2.gms.controller;

import it.inaf.ia2.gms.authn.SessionData;
import it.inaf.ia2.gms.manager.GroupsManager;
import it.inaf.ia2.gms.manager.InvitedRegistrationManager;
import it.inaf.ia2.gms.manager.PermissionsManager;
import it.inaf.ia2.gms.model.GroupNode;
import it.inaf.ia2.gms.model.Permission;
import it.inaf.ia2.gms.model.request.GroupsRequest;
import it.inaf.ia2.gms.model.response.GroupsTabResponse;
import it.inaf.ia2.gms.model.response.PaginatedData;
import it.inaf.ia2.gms.persistence.model.GroupEntity;
import it.inaf.ia2.gms.service.GroupsService;
import it.inaf.ia2.gms.service.GroupsTreeBuilder;
import java.util.ArrayList;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import org.junit.Test;
import org.junit.runner.RunWith;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.ArgumentMatchers.eq;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import static org.mockito.Mockito.when;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(MockitoJUnitRunner.class)
public class GroupsTabResponseBuilderTest {

    @Mock
    private SessionData session;

    @Mock
    private GroupsManager groupsManager;

    @Mock
    private GroupsService groupsService;

    @Mock
    private PermissionsManager permissionsManager;

    @Mock
    private GroupsTreeBuilder groupsTreeBuilder;

    @Mock
    private InvitedRegistrationManager invitedRegistrationManager;

    @InjectMocks
    private GroupsTabResponseBuilder groupsTabResponseBuilder;

    @Test
    public void testGetGroupsTab() {

        when(session.getUserId()).thenReturn("admin_id");

        GroupEntity root = new GroupEntity();
        root.setId("ROOT");
        root.setName("ROOT");
        root.setPath("");

        when(groupsService.getGroupById(eq("ROOT"))).thenReturn(root);

        when(permissionsManager.getCurrentUserPermission(eq(root)))
                .thenReturn(Permission.ADMIN);

        PaginatedData<GroupNode> groupsPanel = new PaginatedData<>(new ArrayList<>(), 1, 10);
        when(groupsTreeBuilder.listSubGroups(eq(root), any(), eq("admin_id"))).thenReturn(groupsPanel);

        GroupsRequest request = new GroupsRequest();
        request.setGroupId("ROOT");
        request.setPaginatorPage(1);
        request.setPaginatorPageSize(10);

        GroupsTabResponse response = groupsTabResponseBuilder.getGroupsTab(request);

        assertNotNull(response.getBreadcrumbs());
        assertNotNull(response.getGroupsPanel());
        assertEquals(Permission.ADMIN, response.getPermission());
    }
}
