package it.inaf.ia2.gms.service;

import it.inaf.ia2.gms.persistence.GroupsDAO;
import it.inaf.ia2.gms.persistence.InvitedRegistrationDAO;
import it.inaf.ia2.gms.persistence.LoggingDAO;
import it.inaf.ia2.gms.persistence.MembershipsDAO;
import it.inaf.ia2.gms.persistence.PermissionsDAO;
import it.inaf.ia2.gms.persistence.model.GroupEntity;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import org.junit.Test;
import org.junit.runner.RunWith;
import static org.mockito.ArgumentMatchers.argThat;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(MockitoJUnitRunner.class)
public class GroupsServiceTest {

    @Mock
    private GroupsDAO groupsDAO;
    @Mock
    private PermissionsDAO permissionsDAO;
    @Mock
    private MembershipsDAO membershipsDAO;
    @Mock
    private InvitedRegistrationDAO invitedRegistrationDAO;
    @Mock
    private LoggingDAO loggingDAO;

    @InjectMocks
    private GroupsService groupsService;

    private final GroupEntity root = group("ROOT", "ROOT", "");

    @Test
    public void testAddGroup() {

        GroupEntity group1 = groupsService.addGroup(root, "group1", false, "creator_id");

        verify(groupsDAO, times(1)).createGroup(argThat(g -> "group1".equals(g.getName())));

        assertNotNull(group1.getId());
        assertEquals("group1", group1.getName());
        assertFalse(group1.isLeaf());
        assertEquals("creator_id", group1.getCreatedBy());
        assertNotNull(group1.getCreationTime());

        GroupEntity group2 = groupsService.addGroup(group1, "group2", true, "creator_id");

        verify(groupsDAO, times(1)).createGroup(argThat(g -> "group2".equals(g.getName())));

        assertNotNull(group2.getId());
        assertEquals("group2", group2.getName());
        assertTrue(group2.isLeaf());
        assertEquals(group1.getId() + "." + group2.getId(), group2.getPath());
    }

    private GroupEntity group(String id, String name, String path) {
        GroupEntity group = new GroupEntity();
        group.setId(id);
        group.setName(name);
        group.setPath(path);
        return group;
    }
}
