import home from './data/home';
import groups from './data/groups';
import groupsPanel from './data/groupsPanel';
import membersPanel from './data/membersPanel';
import permissionsPanel from './data/permissionsPanel';
import searchUser from './data/searchUser';
import permission from './data/permission';
import search from './data/search';
import openUserSearchResult from './data/openUserSearchResult';

const fetch = (mockData, time = 500) => {
  return new Promise((resolve) => {
    setTimeout(() => {
      resolve(mockData)
    }, time);
  });
};

export default {
  fetchHomePageModel() {
    return fetch(home);
  },
  fetchGroupsTab() {
    return fetch(groups);
  },
  fetchGroupsPanel() {
    return fetch(groupsPanel);
  },
  fetchMembersPanel() {
    return fetch(membersPanel);
  },
  fetchPermissionsPanel() {
    return fetch(permissionsPanel);
  },
  addGroup() {
    return fetch(groupsPanel);
  },
  updateGroup() {
    return fetch(groupsPanel);
  },
  removeGroup() {
    return fetch(groupsPanel);
  },
  searchUser() {
    return fetch(searchUser);
  },
  addPermission() {
    return fetch(permissionsPanel);
  },
  updatePermission() {
    return fetch({"permission": "ADMIN"});
  },
  getPermission() {
    return fetch(permission);
  },
  removePermission() {
    return fetch(permissionsPanel);
  },
  addMember() {
    return fetch(membersPanel);
  },
  removeMember() {
    return fetch(membersPanel);
  },
  search() {
    return fetch(search);
  },
  openUserSearchResult() {
    return fetch(openUserSearchResult);
  },
  setKeepAlive() {
    return fetch({});
  }
}
