package it.inaf.ia2.gms;

import it.inaf.ia2.aa.ServiceLocator;
import it.inaf.ia2.rap.client.RapClient;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@SpringBootApplication
@Configuration
@EnableTransactionManagement
public class GmsApplication {

    public static void main(String[] args) {
        SpringApplication.run(GmsApplication.class, args);
    }
    
    @Bean
    public RapClient rapClient() {
        return ServiceLocator.getInstance().getRapClient();
    }
}
