package it.inaf.ia2.gms.controller;

import it.inaf.ia2.gms.authn.SessionData;
import it.inaf.ia2.gms.manager.GroupsManager;
import it.inaf.ia2.gms.manager.PermissionsManager;
import it.inaf.ia2.gms.model.Permission;
import it.inaf.ia2.gms.model.request.GroupsRequest;
import it.inaf.ia2.gms.model.response.GroupsTabResponse;
import it.inaf.ia2.gms.persistence.model.GroupEntity;
import it.inaf.ia2.gms.service.GroupsService;
import it.inaf.ia2.gms.service.GroupsTreeBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GroupsTabResponseBuilder {

    @Autowired
    private SessionData session;

    @Autowired
    private PermissionsManager permissionsManager;

    @Autowired
    private GroupsManager groupsManager;

    @Autowired
    private GroupsService groupsService;

    @Autowired
    private GroupsTreeBuilder groupsListBuilder;

    public GroupsTabResponse getGroupsTab(GroupsRequest request) {

        GroupEntity group = groupsService.getGroupById(request.getGroupId());
        groupsManager.verifyUserCanReadGroup(group);

        GroupsTabResponse response = new GroupsTabResponse();

        response.setBreadcrumbs(groupsService.getBreadcrumbs(group.getPath()));

        Permission permission = permissionsManager.getCurrentUserPermission(group);
        response.setPermission(permission);

        response.setGroupsPanel(groupsListBuilder.listSubGroups(group, request, session.getUserId()));

        response.setLeaf(group.isLeaf());

        return response;
    }
}
