package it.inaf.ia2.gms.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;

public enum IdentityType {

    EDU_GAIN("EduGAIN"),
    X509("X.509"),
    ORCID("OrcID"),
    GOOGLE("Google"),
    LINKEDIN("LinkedIn"),
    FACEBOOK("Facebook"),
    LOCAL_IDP("LocalIdP");

    private final String value;

    IdentityType(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    @JsonCreator
    public static IdentityType forValue(String value) {
        return Arrays.stream(IdentityType.values())
                .filter(it -> value.equals(it.value)).findFirst().get();
    }

    @JsonValue
    public String toValue() {
        return value;
    }
}
