import home from './data/home';
import groups from './data/groups';
import groupsPanel from './data/groupsPanel';
import membersPanel from './data/membersPanel';
import permissionsPanel from './data/permissionsPanel';
import searchUser from './data/searchUser';
import permission from './data/permission';

const fetch = (mockData, time = 0) => {
  return new Promise((resolve) => {
    setTimeout(() => {
      resolve(mockData)
    }, time);
  });
};

export default {
  fetchHomePageModel() {
    return fetch(home, 500);
  },
  fetchGroupsTab() {
    return fetch(groups, 500);
  },
  fetchGroupsPanel() {
    return fetch(groupsPanel, 500);
  },
  fetchMembersPanel() {
    return fetch(membersPanel, 500);
  },
  fetchPermissionsPanel() {
    return fetch(permissionsPanel, 500);
  },
  addGroup() {
    return fetch(groupsPanel, 500);
  },
  renameGroup() {
    return fetch(groupsPanel, 500);
  },
  removeGroup() {
    return fetch(groupsPanel, 500);
  },
  searchUser() {
    return fetch(searchUser, 500);
  },
  addPermission() {
    return fetch(permissionsPanel, 500);
  },
  getPermission() {
    return fetch(permission, 500);
  },
  removePermission() {
    return fetch(permissionsPanel, 500);
  },
  addMember() {
    return fetch(membersPanel, 500);
  },
  removeMember() {
    return fetch(membersPanel, 500);
  }
}
