#ifndef PROTOCOLMANAGER_H
#define	PROTOCOLMANAGER_H

#include <Response.pb.h>
#include <Request.pb.h>
#include <Configuration.h>
#include <DBManager.h>

#include <tango.h>

namespace MetadataExporter_ns
{

//Protocol buffer request class shared pointer
typedef boost::shared_ptr<Request> RequestSP;

//Protocol buffer response class shared pointer
typedef boost::shared_ptr<Response> ResponseSP;

class ProtocolManager : public Tango::LogAdapter
{
public:
//------------------------------------------------------------------------------
//  [Public] Shared pointer typedef
//------------------------------------------------------------------------------
    typedef boost::shared_ptr<ProtocolManager> SP;

protected:
//------------------------------------------------------------------------------
//  [Protected] Constructor destructor deleter
//------------------------------------------------------------------------------
    ProtocolManager(Tango::DeviceImpl*, Configuration::SP, DBManager::SP);

    virtual ~ProtocolManager();

    class Deleter;
    friend class Deleter;
    class Deleter
    {
        public:
            void operator()(ProtocolManager* d) { delete d; }
    };

public:
//------------------------------------------------------------------------------
//	[Public] Class creation method
//------------------------------------------------------------------------------
    static ProtocolManager::SP create(Tango::DeviceImpl*, Configuration::SP,
        DBManager::SP);

//------------------------------------------------------------------------------
//	[Public] Remote endpoint setter method
//------------------------------------------------------------------------------
    void setRemoteEndpoint(std::string);

//------------------------------------------------------------------------------
//  [Public] Request response management method
//------------------------------------------------------------------------------
    virtual ResponseSP prepareResponse(RequestSP)
        throw(std::runtime_error);

protected:
//------------------------------------------------------------------------------
//  [Protected] Request specific methods
//------------------------------------------------------------------------------
    virtual ResponseSP prepareAuthroisation(RequestSP);

    virtual ResponseSP prepareValidation(RequestSP);

    virtual ResponseSP prepareMetadata(RequestSP);

//------------------------------------------------------------------------------
//  [Protected] Columns validation method
//------------------------------------------------------------------------------
    virtual void validateColumn(const Request::Validation::Column&,
        DBManager::InformationList&) throw(std::runtime_error);

//------------------------------------------------------------------------------
//  [Protected] Metadata serialization method
//------------------------------------------------------------------------------
    virtual void fillMetadata(Response::Metadata*)
        throw(std::runtime_error, std::out_of_range);

    virtual void fillRow(Response::Metadata::Row*)
        throw(std::runtime_error, std::out_of_range);

//------------------------------------------------------------------------------
//  [Protected] Class variables
//------------------------------------------------------------------------------
    //Configuration parameters shared pointer
    Configuration::SP m_configuration_sp;

    //Database manger shared pointer
    DBManager::SP m_dBManager_sp;

    //Client is authorised
    bool m_isAuthorised;

    //Table is validated
    bool m_isValidated;

    //Validate schema name
    std::string m_validatedSchema;

    //Validate table name
    std::string m_validatedTable;

    //Retrieved data iterator
    soci::rowset<soci::row>::const_iterator m_it;

    //Retrieved data shared pointer
    boost::shared_ptr< soci::rowset<soci::row> > m_rowSet_sp;

    //Address and port of remote endpoint
    std::string m_remoteEndpoint;
};

}   //End of namespace

#endif	/* PROTOCOLMANAGER_H */

