#ifndef WORKERTHREAD_H
#define	WORKERTHREAD_H

#include <tango.h>

#include <boost/shared_ptr.hpp>
#include <boost/asio/io_service.hpp>

namespace MetadataExporter_ns
{

class WorkerThread : public Tango::LogAdapter
{
public:    
//------------------------------------------------------------------------------
//	[Public] Constructor destructor
//------------------------------------------------------------------------------
	WorkerThread(Tango::DeviceImpl*, boost::shared_ptr<boost::asio::io_service>);
	virtual ~WorkerThread();

//------------------------------------------------------------------------------
//	[Public] Users method
//------------------------------------------------------------------------------
	virtual void run();

protected:
//------------------------------------------------------------------------------
//	[Protected] Class variables
//------------------------------------------------------------------------------
    //Io service object common to all threads
    boost::shared_ptr<boost::asio::io_service> m_ioService_sp;    
};
    
}   //End of namespace

#endif	/* WORKERTHREAD_H */

