#include <WorkerThread.h>
#include <boost/thread.hpp>

namespace MetadataExporter_ns
{

//==============================================================================
//	WorkerThread::WorkerThread()
//==============================================================================
WorkerThread::WorkerThread(Tango::DeviceImpl* deviceImpl_p,
    boost::shared_ptr<boost::asio::io_service> ioService_sp) :
    Tango::LogAdapter(deviceImpl_p), m_ioService_sp(ioService_sp)
{
    DEBUG_STREAM << "WorkerThread::WorkerThread()" << endl;
}

//==============================================================================
//	WorkerThread::~WorkerThread()
//==============================================================================
WorkerThread::~WorkerThread()
{
    DEBUG_STREAM << "WorkerThread::~WorkerThread()" << endl;
}

//==============================================================================
//	WorkerThread::run()
//==============================================================================
void WorkerThread::run()
{
    DEBUG_STREAM << "WorkerThread::run() Starting" << endl;

    while(true)
    {
        try
        {
            boost::system::error_code ec;
            m_ioService_sp->run(ec);

            if(ec)
            {
                ERROR_STREAM << "WorkerThread::run() " << ec.message() << endl;
            }
            break;
        }
        catch(std::exception& ex)
        {
            ERROR_STREAM << "WorkerThread::run() " << ex.what() << endl;
        }
        catch(boost::thread_interrupted& ex)
        {
            DEBUG_STREAM << "WorkerThread::run() interrupt" << endl;
            break;
        }
    }

    DEBUG_STREAM << "WorkerThread::run() Stopping" << endl;
}

}