#include <DBManager.h>

#include <soci/mysql/soci-mysql.h>

namespace MetadataExporter_ns
{

//==============================================================================
//      DBManager::DBManager()
//==============================================================================
DBManager::DBManager(Tango::DeviceImpl* deviceImpl_p,
    Configuration::SP configuration_sp) : Tango::LogAdapter(deviceImpl_p),
    m_configuration_sp(configuration_sp)
{
    DEBUG_STREAM << "DBManager::DBManager()" << endl;

    unsigned int connectionNumber = m_configuration_sp->getDatabaseConnectionNumber();

    m_connectionPool_sp.reset(new soci::connection_pool(connectionNumber));
}

//==============================================================================
//      DBManager::DBManager()
//==============================================================================
DBManager::~DBManager()
{
    DEBUG_STREAM << "DBManager::~DBManager()" << endl;
}

//==============================================================================
//      DBManager::DBManager()
//==============================================================================
DBManager::SP DBManager::create(Tango::DeviceImpl* deviceImpl_p,
    Configuration::SP configuration_sp)
{
    DBManager::SP d_sp(new DBManager(deviceImpl_p, configuration_sp),
        DBManager::Deleter());

    return d_sp;
}

//==============================================================================
//      DBManager::connect()
//==============================================================================
void DBManager::connect() throw(soci::soci_error)
{
    DEBUG_STREAM << "DBManager::connect()" << endl;

//    std::stringstream connection;
//    connection << " host=" << m_configuration_sp->getDatabaseHost();
//    connection << " port=" << m_configuration_sp->getDatabasePort();
//    connection << " user=" << m_configuration_sp->getDatabaseUsername();
//    connection << " password=" << m_configuration_sp->getDatabasePassword();
//
//    unsigned int connectionNumber = m_configuration_sp->getDatabaseConnectionNumber();
//
//    for(unsigned int i=0; i<connectionNumber; ++i)
//    {
//        m_connectionPool_sp->at(i).open(soci::mysql, connection.str());
//
//        #ifdef VERBOSE_DEBUG
//            INFO_STREAM << "CONNECTION: " << connection.str() << " -> OPEN" << endl;
//        #endif
//    }
}

//==============================================================================
//      DBManager::disconnect()
//==============================================================================
void DBManager::disconnect()
{
    DEBUG_STREAM << "DBManager::disconnect()" << endl;

//    std::stringstream connection;
//    connection << " host=" << m_configuration_sp->getDatabaseHost();
//    connection << " port=" << m_configuration_sp->getDatabasePort();
//    connection << " user=" << m_configuration_sp->getDatabaseUsername();
//    connection << " password=" << m_configuration_sp->getDatabasePassword();
//
//    unsigned int connectionNumber = m_configuration_sp->getDatabaseConnectionNumber();
//
//    for(unsigned int i=0; i<connectionNumber; ++i)
//    {
//        m_connectionPool_sp->at(i).close();
//
//        #ifdef VERBOSE_DEBUG
//            INFO_STREAM << "CONNECTION: " << connection.str() << " -> CLOSE" << endl;
//        #endif
//    }
}

}   //namespace
