#ifndef DBMANAGER_H
#define	DBMANAGER_H

#include <Configuration.h>

#include <tango.h>

#include <boost/scoped_ptr.hpp>
#include <boost/thread/mutex.hpp>

#include <soci/error.h>
#include <soci/session.h>
#include <soci/connection-pool.h>

namespace MetadataExporter_ns
{

class DBManager : public Tango::LogAdapter
{
public:
//------------------------------------------------------------------------------
//  [Public] Shared pointer typedef
//------------------------------------------------------------------------------
    typedef boost::shared_ptr<DBManager> SP;

protected:
//------------------------------------------------------------------------------
//  [Protected] Constructor destructor deleter
//------------------------------------------------------------------------------
    DBManager(Tango::DeviceImpl*, Configuration::SP);

    virtual ~DBManager();

    class Deleter;
    friend Deleter;
    class Deleter
    {
        public:
            void operator()(DBManager* d) { delete d; }
    };

public:
//------------------------------------------------------------------------------
//	[Public] Class creation method
//------------------------------------------------------------------------------
    static DBManager::SP create(Tango::DeviceImpl*, Configuration::SP);

//------------------------------------------------------------------------------
//  [Public] Connection management methods
//------------------------------------------------------------------------------
    virtual void connect() throw(soci::soci_error);

    virtual void disconnect();

//------------------------------------------------------------------------------
//  [Public] Data access methods
//------------------------------------------------------------------------------

protected:
//------------------------------------------------------------------------------
//  [Protected] Class variables
//------------------------------------------------------------------------------
    //Configuration shared pointer
    Configuration::SP m_configuration_sp;

    //Connection pool mutex
    boost::mutex m_connectionPoolMutex;

    //Database connection pool scoped pointer
    boost::scoped_ptr<soci::connection_pool> m_connectionPool_sp;
};

}   //End of namespace

#endif	/* DBMANAGER_H */
