/*----- PROTECTED REGION ID(MetadataExporter.cpp) ENABLED START -----*/
//=============================================================================
//
// file :        MetadataExporter.cpp
//
// description : C++ source for the MetadataExporter class and its commands.
//               The class is derived from Device. It represents the
//               CORBA servant object which will be accessed from the
//               network. All commands which can be executed on the
//               MetadataExporter are implemented in this file.
//
// project :     Metadata exporter device server
//
// This file is part of Tango device class.
//
// Tango is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Tango is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with Tango.  If not, see <http://www.gnu.org/licenses/>.
//
// $Author:  $
//
// $Revision:  $
// $Date:  $
//
// $HeadURL:  $
//
//=============================================================================
//                This file is generated by POGO
//        (Program Obviously used to Generate tango Object)
//=============================================================================


#include <MetadataExporter.h>
#include <MetadataExporterClass.h>
#include <Configuration.h>
#include <PlainServer.h>
#include <SSLServer.h>

#include <boost/filesystem.hpp>

/*----- PROTECTED REGION END -----*/	//	MetadataExporter.cpp

/**
 *  MetadataExporter class description:
 *    Metadata exporter device server
 */

//================================================================
//  The following table gives the correspondence
//  between command and method names.
//
//  Command name  |  Method name
//================================================================
//  State         |  Inherited (no method)
//  Status        |  Inherited (no method)
//  On            |  on
//  Off           |  off
//================================================================

//================================================================
//  Attributes managed is:
//================================================================
//================================================================

namespace MetadataExporter_ns
{
/*----- PROTECTED REGION ID(MetadataExporter::namespace_starting) ENABLED START -----*/

//	static initializations

/*----- PROTECTED REGION END -----*/	//	MetadataExporter::namespace_starting

//--------------------------------------------------------
/**
 *	Method      : MetadataExporter::MetadataExporter()
 *	Description : Constructors for a Tango device
 *                implementing the classMetadataExporter
 */
//--------------------------------------------------------
MetadataExporter::MetadataExporter(Tango::DeviceClass *cl, string &s)
 : TANGO_BASE_CLASS(cl, s.c_str())
{
	/*----- PROTECTED REGION ID(MetadataExporter::constructor_1) ENABLED START -----*/
	init_device();

	/*----- PROTECTED REGION END -----*/	//	MetadataExporter::constructor_1
}
//--------------------------------------------------------
MetadataExporter::MetadataExporter(Tango::DeviceClass *cl, const char *s)
 : TANGO_BASE_CLASS(cl, s)
{
	/*----- PROTECTED REGION ID(MetadataExporter::constructor_2) ENABLED START -----*/
	init_device();

	/*----- PROTECTED REGION END -----*/	//	MetadataExporter::constructor_2
}
//--------------------------------------------------------
MetadataExporter::MetadataExporter(Tango::DeviceClass *cl, const char *s, const char *d)
 : TANGO_BASE_CLASS(cl, s, d)
{
	/*----- PROTECTED REGION ID(MetadataExporter::constructor_3) ENABLED START -----*/
	init_device();

	/*----- PROTECTED REGION END -----*/	//	MetadataExporter::constructor_3
}

//--------------------------------------------------------
/**
 *	Method      : MetadataExporter::delete_device()
 *	Description : will be called at device destruction or at init command
 */
//--------------------------------------------------------
void MetadataExporter::delete_device()
{
	DEBUG_STREAM << "MetadataExporter::delete_device() " << device_name << endl;
	/*----- PROTECTED REGION ID(MetadataExporter::delete_device) ENABLED START -----*/

	//	Delete device allocated objects

	/*----- PROTECTED REGION END -----*/	//	MetadataExporter::delete_device
}

//--------------------------------------------------------
/**
 *	Method      : MetadataExporter::init_device()
 *	Description : will be called at device initialization.
 */
//--------------------------------------------------------
void MetadataExporter::init_device()
{
	DEBUG_STREAM << "MetadataExporter::init_device() create device " << device_name << endl;
	/*----- PROTECTED REGION ID(MetadataExporter::init_device_before) ENABLED START -----*/

    set_state(Tango::INIT);
    set_status("Initializing device");

	/*----- PROTECTED REGION END -----*/	//	MetadataExporter::init_device_before


	//	Get the device properties from database
	get_device_property();


	/*----- PROTECTED REGION ID(MetadataExporter::init_device) ENABLED START -----*/

    if(get_state() != Tango::FAULT)
    {
        try
        {
            if(enableSSL)
                m_server_sp = SSLServer::create(this, m_configuration_sp);
            else
                m_server_sp = PlainServer::create(this, m_configuration_sp);
        }
        catch(std::exception& ex)
        {
            set_state(Tango::FAULT);
            std::stringstream error_stream;
            error_stream << "MetadataExporter::init_device() " << ex.what() << std::endl;
            set_status(error_stream.str());
        }
        catch(...)
        {
            set_state(Tango::FAULT);
            set_status("MetadataExporter::init_device() unknown error");
        }
    }

	/*----- PROTECTED REGION END -----*/	//	MetadataExporter::init_device
}

//--------------------------------------------------------
/**
 *	Method      : MetadataExporter::get_device_property()
 *	Description : Read database to initialize property data members.
 */
//--------------------------------------------------------
void MetadataExporter::get_device_property()
{
	/*----- PROTECTED REGION ID(MetadataExporter::get_device_property_before) ENABLED START -----*/

    //Exported tables multi map [schema table]
    std::multimap<const std::string, const std::string> exportedTablesMap;

    //Authorised user map [user password]
    std::map<const std::string, const std::string> authorisedUsersMap;

	/*----- PROTECTED REGION END -----*/	//	MetadataExporter::get_device_property_before


	//	Read device properties from database.
	Tango::DbData	dev_prop;
	dev_prop.push_back(Tango::DbDatum("CertificateFile"));
	dev_prop.push_back(Tango::DbDatum("PrivateKeyFile"));
	dev_prop.push_back(Tango::DbDatum("DHTempFile"));
	dev_prop.push_back(Tango::DbDatum("LocalHost"));
	dev_prop.push_back(Tango::DbDatum("LocalPort"));
	dev_prop.push_back(Tango::DbDatum("WorkerNumber"));
	dev_prop.push_back(Tango::DbDatum("EnableSSL"));
	dev_prop.push_back(Tango::DbDatum("DatabaseHost"));
	dev_prop.push_back(Tango::DbDatum("DatabasePort"));
	dev_prop.push_back(Tango::DbDatum("DatabaseUsername"));
	dev_prop.push_back(Tango::DbDatum("DatabasePassword"));
	dev_prop.push_back(Tango::DbDatum("DatabaseConnectionNumber"));
	dev_prop.push_back(Tango::DbDatum("ExportedTables"));
	dev_prop.push_back(Tango::DbDatum("AuthorisedUsers"));

	//	is there at least one property to be read ?
	if (dev_prop.size()>0)
	{
		//	Call database and extract values
		if (Tango::Util::instance()->_UseDb==true)
			get_db_device()->get_property(dev_prop);

		//	get instance on MetadataExporterClass to get class property
		Tango::DbDatum	def_prop, cl_prop;
		MetadataExporterClass	*ds_class =
			(static_cast<MetadataExporterClass *>(get_device_class()));
		int	i = -1;

		//	Try to initialize CertificateFile from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  certificateFile;
		else {
			//	Try to initialize CertificateFile from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  certificateFile;
		}
		//	And try to extract CertificateFile value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  certificateFile;

		//	Try to initialize PrivateKeyFile from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  privateKeyFile;
		else {
			//	Try to initialize PrivateKeyFile from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  privateKeyFile;
		}
		//	And try to extract PrivateKeyFile value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  privateKeyFile;

		//	Try to initialize DHTempFile from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  dHTempFile;
		else {
			//	Try to initialize DHTempFile from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  dHTempFile;
		}
		//	And try to extract DHTempFile value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  dHTempFile;

		//	Try to initialize LocalHost from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  localHost;
		else {
			//	Try to initialize LocalHost from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  localHost;
		}
		//	And try to extract LocalHost value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  localHost;

		//	Try to initialize LocalPort from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  localPort;
		else {
			//	Try to initialize LocalPort from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  localPort;
		}
		//	And try to extract LocalPort value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  localPort;

		//	Try to initialize WorkerNumber from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  workerNumber;
		else {
			//	Try to initialize WorkerNumber from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  workerNumber;
		}
		//	And try to extract WorkerNumber value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  workerNumber;

		//	Try to initialize EnableSSL from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  enableSSL;
		else {
			//	Try to initialize EnableSSL from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  enableSSL;
		}
		//	And try to extract EnableSSL value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  enableSSL;

		//	Try to initialize DatabaseHost from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  databaseHost;
		else {
			//	Try to initialize DatabaseHost from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  databaseHost;
		}
		//	And try to extract DatabaseHost value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  databaseHost;

		//	Try to initialize DatabasePort from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  databasePort;
		else {
			//	Try to initialize DatabasePort from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  databasePort;
		}
		//	And try to extract DatabasePort value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  databasePort;

		//	Try to initialize DatabaseUsername from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  databaseUsername;
		else {
			//	Try to initialize DatabaseUsername from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  databaseUsername;
		}
		//	And try to extract DatabaseUsername value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  databaseUsername;

		//	Try to initialize DatabasePassword from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  databasePassword;
		else {
			//	Try to initialize DatabasePassword from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  databasePassword;
		}
		//	And try to extract DatabasePassword value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  databasePassword;

		//	Try to initialize DatabaseConnectionNumber from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  databaseConnectionNumber;
		else {
			//	Try to initialize DatabaseConnectionNumber from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  databaseConnectionNumber;
		}
		//	And try to extract DatabaseConnectionNumber value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  databaseConnectionNumber;

		//	Try to initialize ExportedTables from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  exportedTables;
		else {
			//	Try to initialize ExportedTables from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  exportedTables;
		}
		//	And try to extract ExportedTables value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  exportedTables;

		//	Try to initialize AuthorisedUsers from class property
		cl_prop = ds_class->get_class_property(dev_prop[++i].name);
		if (cl_prop.is_empty()==false)	cl_prop  >>  authorisedUsers;
		else {
			//	Try to initialize AuthorisedUsers from default device value
			def_prop = ds_class->get_default_device_property(dev_prop[i].name);
			if (def_prop.is_empty()==false)	def_prop  >>  authorisedUsers;
		}
		//	And try to extract AuthorisedUsers value from database
		if (dev_prop[i].is_empty()==false)	dev_prop[i]  >>  authorisedUsers;

	}

	/*----- PROTECTED REGION ID(MetadataExporter::get_device_property_after) ENABLED START -----*/

    try
    {
        if(localHost.empty())
            throw(invalid_argument("LocalHost property is empty or not defined"));

        if(localPort<1 || localPort>MAX_LOCAL_PORT)
            throw(invalid_argument("LocalPort property out of range or not defined"));

        if(workerNumber<1 || workerNumber>MAX_WORKER_NUMBER)
            throw(invalid_argument("WorkerNumber property out of range or not defined"));

        if(enableSSL)
        {
            if(certificateFile.empty())
                throw(invalid_argument("CertificateFile property is empty or not defined"));

            checkIfFileExists(certificateFile);

            if(privateKeyFile.empty())
                throw(invalid_argument("PrivateKeyFile property is empty or not defined"));

            checkIfFileExists(privateKeyFile);

            if(dHTempFile.empty())
                throw(invalid_argument("DHTempFile property is empty or not defined"));

            checkIfFileExists(dHTempFile);
        }

        if(databaseHost.empty())
            throw(invalid_argument("DatabaseHost property is empty or not defined"));

        if(databasePort<1 || databasePort>MAX_DB_PORT)
            throw(invalid_argument("DatabasePort property out of range or not defined"));

        if(databaseUsername.empty())
            throw(invalid_argument("DatabaseUsername property is empty or not defined"));

        if(databasePassword.empty())
            throw(invalid_argument("DatabasePassword property is empty or not defined"));

        if(databaseConnectionNumber<1 || databaseConnectionNumber>MAX_DB_CONNECTION_NUMBER)
            throw(invalid_argument("DatabaseConnectionNumber property out of range or not defined"));

        if(exportedTables.empty())
            throw(invalid_argument("ExportedTables property is empty or not defined"));

        importExportedTables(exportedTables, exportedTablesMap);

        if(authorisedUsers.empty())
            throw(invalid_argument("AuthorisedUsers property is empty or not defined"));

        importAuthorisedUsers(authorisedUsers, authorisedUsersMap);

        m_configuration_sp = Configuration::create(certificateFile,
            privateKeyFile, dHTempFile, localHost, localPort, workerNumber,
            databaseHost, databasePort, databaseUsername, databasePassword,
            databaseConnectionNumber, exportedTablesMap, authorisedUsersMap);
    }
    catch(invalid_argument& ex)
    {
        set_state(Tango::FAULT);
        stringstream error_stream;
        error_stream << "MetadataExporter::get_device_property() " << ex.what() << endl;
        set_status(error_stream.str());
    }

	/*----- PROTECTED REGION END -----*/	//	MetadataExporter::get_device_property_after
}

//--------------------------------------------------------
/**
 *	Method      : MetadataExporter::always_executed_hook()
 *	Description : method always executed before any command is executed
 */
//--------------------------------------------------------
void MetadataExporter::always_executed_hook()
{
	DEBUG_STREAM << "MetadataExporter::always_executed_hook()  " << device_name << endl;
	/*----- PROTECTED REGION ID(MetadataExporter::always_executed_hook) ENABLED START -----*/

    if(get_state() != Tango::FAULT)
    {
        if(m_server_sp)
        {
            set_state(m_server_sp->readState());

            set_status(m_server_sp->readStatus());
        }
    }

	/*----- PROTECTED REGION END -----*/	//	MetadataExporter::always_executed_hook
}

//--------------------------------------------------------
/**
 *	Method      : MetadataExporter::read_attr_hardware()
 *	Description : Hardware acquisition for attributes
 */
//--------------------------------------------------------
void MetadataExporter::read_attr_hardware(TANGO_UNUSED(vector<long> &attr_list))
{
	DEBUG_STREAM << "MetadataExporter::read_attr_hardware(vector<long> &attr_list) entering... " << endl;
	/*----- PROTECTED REGION ID(MetadataExporter::read_attr_hardware) ENABLED START -----*/

	//	Add your own code

	/*----- PROTECTED REGION END -----*/	//	MetadataExporter::read_attr_hardware
}


//--------------------------------------------------------
/**
 *	Method      : MetadataExporter::add_dynamic_attributes()
 *	Description : Create the dynamic attributes if any
 *                for specified device.
 */
//--------------------------------------------------------
void MetadataExporter::add_dynamic_attributes()
{
	/*----- PROTECTED REGION ID(MetadataExporter::add_dynamic_attributes) ENABLED START -----*/

	//	Add your own code to create and add dynamic attributes if any

	/*----- PROTECTED REGION END -----*/	//	MetadataExporter::add_dynamic_attributes
}

//--------------------------------------------------------
/**
 *	Command On related method
 *	Description: Activate metadata exporter
 *
 */
//--------------------------------------------------------
void MetadataExporter::on()
{
	DEBUG_STREAM << "MetadataExporter::On()  - " << device_name << endl;
	/*----- PROTECTED REGION ID(MetadataExporter::on) ENABLED START -----*/

    try
    {
        if(m_server_sp)
            m_server_sp->start();
    }
    catch(std::exception& ex)
    {
        set_state(Tango::FAULT);
        std::stringstream error_stream;
        error_stream << "MetadataExporter::On() " << ex.what() << std::endl;
        set_status(error_stream.str());
    }
    catch(...)
    {
        set_state(Tango::FAULT);
        set_status("MetadataExporter::On() unknown error");
    }

	/*----- PROTECTED REGION END -----*/	//	MetadataExporter::on
}
//--------------------------------------------------------
/**
 *	Command Off related method
 *	Description: Deactivate fits importer
 *
 */
//--------------------------------------------------------
void MetadataExporter::off()
{
	DEBUG_STREAM << "MetadataExporter::Off()  - " << device_name << endl;
	/*----- PROTECTED REGION ID(MetadataExporter::off) ENABLED START -----*/

    try
    {
        if(m_server_sp)
            m_server_sp->stop();
    }
    catch(std::exception& ex)
    {
        set_state(Tango::FAULT);
        std::stringstream error_stream;
        error_stream << "MetadataExporter::Off() " << ex.what() << std::endl;
        set_status(error_stream.str());
    }
    catch(...)
    {
        set_state(Tango::FAULT);
        set_status("MetadataExporter::Off() unknown error");
    }

	/*----- PROTECTED REGION END -----*/	//	MetadataExporter::off
}

/*----- PROTECTED REGION ID(MetadataExporter::namespace_ending) ENABLED START -----*/

//==============================================================================
//      MetadataExporter::importExportedTables()
//==============================================================================
void MetadataExporter::importExportedTables(std::vector<std::string>& exportedTables,
    std::multimap<const std::string, const std::string>& exportedTablesMap)
    throw(std::invalid_argument)
{
    DEBUG_STREAM << "MetadataExporter::importExportedTables()  - " << device_name << endl;

    for(unsigned int i=0; i<exportedTables.size(); ++i)
    {
        std::size_t found;

        if((found=exportedTables.at(i).find(' ')) == std::string::npos)
        {
            std::stringstream errorStream;
            errorStream << "ExportedTables property has invalid key at "
                << i << " position" << std::endl;
            throw std::invalid_argument(errorStream.str());
        }

        std::string schema = exportedTables.at(i).substr(0, found);
        std::string table = exportedTables.at(i).substr(found+1, std::string::npos);

        INFO_STREAM << "MetadataExporter::importExportedTables() schema "
            << schema << " table " << table << endl;

        exportedTablesMap.insert(std::pair<const std::string, const std::string> (schema, table));
    }
}

//==============================================================================
//      MetadataExporter::importAuthorisedUsers()
//==============================================================================
void MetadataExporter::importAuthorisedUsers(std::vector<std::string>& authorisedUsers,
    std::map<const std::string, const std::string>& authorisedUsersMap)
    throw(std::invalid_argument)
{
    DEBUG_STREAM << "MetadataExporter::importAuthorisedUsers()  - " << device_name << endl;

    for(unsigned int i=0; i<authorisedUsers.size(); ++i)
    {
        std::size_t found;

        if((found=authorisedUsers.at(i).find(' ')) == std::string::npos)
        {
            std::stringstream errorStream;
            errorStream << "AuthorisedUsers property has invalid key at "
                << i << " position" << std::endl;
            throw std::invalid_argument(errorStream.str());
        }

        std::string user = authorisedUsers.at(i).substr(0, found);
        std::string password = authorisedUsers.at(i).substr(found+1, std::string::npos);

        #ifdef VERBOSE_DEBUG
            INFO_STREAM << "MetadataExporter::importAuthorisedUsers() user "
                << user << " password " << password << endl;
        #endif

        authorisedUsersMap.insert(std::pair<const std::string,
            const std::string>(user, password));
    }
}

//==============================================================================
//      MetadataExporter::checkIfFileExists()
//==============================================================================
void MetadataExporter::checkIfFileExists(std::string fileName)
    throw(std::invalid_argument)
{
    DEBUG_STREAM << "MetadataExporter::checkIfFileExists()  - " << device_name << endl;

    boost::filesystem::path path(fileName);

    if(!boost::filesystem::exists(path))
    {
        std::stringstream errorStream;
        errorStream << "File " << fileName << " not exists" << std::endl;
        throw std::invalid_argument(errorStream.str());
    }

    INFO_STREAM << "MetadataExporter::checkIfFileExists() " << fileName << endl;
}

/*----- PROTECTED REGION END -----*/	//	MetadataExporter::namespace_ending
} //	namespace
