#ifndef PLAINSESSION_H
#define	PLAINSESSION_H

#include <Session.h>

#include <tango.h>

#include <boost/enable_shared_from_this.hpp>

namespace MetadataExporter_ns
{

class PlainSession : public Session,
    public boost::enable_shared_from_this<PlainSession>
{
protected:
//------------------------------------------------------------------------------
//	[Protected] Constructor destructor deleter
//------------------------------------------------------------------------------
    PlainSession(Tango::DeviceImpl*, Configuration::SP, DBManager::SP,
        boost::shared_ptr<boost::asio::io_service>);

    virtual ~PlainSession();

    class Deleter;
    friend Deleter;
    class Deleter
    {
	public:
		void operator()(PlainSession* d) { delete d; }
    };

public:
//------------------------------------------------------------------------------
//	[Public] Class creation method
//------------------------------------------------------------------------------
    static Session::SP create(Tango::DeviceImpl*, Configuration::SP,
        DBManager::SP, boost::shared_ptr<boost::asio::io_service>);

//------------------------------------------------------------------------------
//	[Public] Incoming connection methods
//------------------------------------------------------------------------------
    virtual boost::asio::ip::tcp::socket& getSocket();

    virtual void start();

protected:
//------------------------------------------------------------------------------
//  [Protected] Request response methods
//------------------------------------------------------------------------------
    virtual void startReadRequestHeader();

    virtual void startReadRequestBody(boost::uint32_t);

    virtual void startWriteResponse();

//------------------------------------------------------------------------------
//	[Protected] Class variables
//------------------------------------------------------------------------------
    //TCP socket object
    boost::asio::ip::tcp::socket m_plainSocket;
};

}   //End of namespace

#endif	/* PLAINSESSION_H */

