#ifndef SESSION_H
#define SESSION_H

#include <Configuration.h>
#include <DBManager.h>
#include <ProtocolManager.h>
#include <Response.pb.h>
#include <Request.pb.h>

#include <tango.h>

#include <boost/asio.hpp>
#include <boost/shared_ptr.hpp>
#include <boost/cstdint.hpp>

namespace MetadataExporter_ns
{

class Session : public Tango::LogAdapter
{
public:
//------------------------------------------------------------------------------
//  [Public] Shared pointer typedef
//------------------------------------------------------------------------------
    typedef boost::shared_ptr<Session> SP;

protected:
//------------------------------------------------------------------------------
//	[Protected] Constructor destructor deleter
//------------------------------------------------------------------------------
    Session(Tango::DeviceImpl*, Configuration::SP, DBManager::SP,
        boost::shared_ptr<boost::asio::io_service>);

    virtual ~Session();

public:
//------------------------------------------------------------------------------
//	[Public] Incoming connection methods
//------------------------------------------------------------------------------
    virtual boost::asio::ip::tcp::socket& getSocket() = 0;

    virtual void start() = 0;

protected:
//------------------------------------------------------------------------------
//  [Protected] Read request header methods
//------------------------------------------------------------------------------
    virtual void startReadRequestHeader() = 0;

    virtual void handleReadRequestHeader(const boost::system::error_code&);

//------------------------------------------------------------------------------
//  [Protected] Read request body methods
//------------------------------------------------------------------------------
    virtual void startReadRequestBody(boost::uint32_t) = 0;

    virtual void handleReadRequestBody(const boost::system::error_code&);

//------------------------------------------------------------------------------
//  [Protected] Write response methods
//------------------------------------------------------------------------------
    virtual void startWriteResponse() = 0;

    virtual void handleWriteResponse(const boost::system::error_code&);

//------------------------------------------------------------------------------
//  [Protected] Encode decode header methods
//------------------------------------------------------------------------------
    virtual void encodeHeader(std::vector<boost::uint8_t>&, boost::uint32_t)
        throw(std::runtime_error);

    virtual boost::uint32_t decodeHeader(std::vector<boost::uint8_t>&)
        throw(std::runtime_error);

//------------------------------------------------------------------------------
//	[Protected] Class variables
//------------------------------------------------------------------------------
    //Configuration parameters shared pointer
    Configuration::SP m_configuration_sp;

    //Protocol manager class shared pointer
    ProtocolManager::SP m_protocolManager_sp;

    //Synchronization mechanism
    boost::asio::io_service::strand m_strand;

    //Header size written on socket
    const unsigned int HEADER_SIZE = 4;

    //Binary buffer for read data
    std::vector<boost::uint8_t> m_readBuff;
};

}   //End of namespace

#endif	/* SESSION_H */

