#ifndef PLAINSERVER_H
#define	PLAINSERVER_H

#include <Server.h>
#include <Configuration.h>

namespace MetadataExporter_ns
{

class PlainServer : public Server
{
//------------------------------------------------------------------------------
//	[Protected] Constructor destructor deleter
//------------------------------------------------------------------------------
    PlainServer(Tango::DeviceImpl*, Configuration::SP);

    virtual ~PlainServer();

    class Deleter;
    friend Deleter;
    class Deleter
    {
	public:
		void operator()(PlainServer* d) { delete d; }
    };

public:
//------------------------------------------------------------------------------
//	[Public] Class creation method
//------------------------------------------------------------------------------
    static Server::SP create(Tango::DeviceImpl*, Configuration::SP);

//------------------------------------------------------------------------------
//  [Protected] Incoming connection method
//------------------------------------------------------------------------------
    virtual void startAccept();
};

}   //End of namespace

#endif	/* PLAINSERVER_H */

