#ifndef DBMANAGER_H
#define	DBMANAGER_H

#include <Configuration.h>

#include <tango.h>

#include <ctime>

#include <boost/tuple/tuple.hpp>
#include <boost/optional/optional.hpp>
#include <boost/scoped_ptr.hpp>
#include <boost/thread/mutex.hpp>

#include <soci/soci.h>
#include <soci/error.h>
#include <soci/row.h>
#include <soci/rowset.h>
#include <soci/boost-tuple.h>
#include <soci/boost-optional.h>
#include <soci/session.h>
#include <soci/connection-pool.h>

namespace MetadataExporter_ns
{

class DBManager : public Tango::LogAdapter
{
public:
//------------------------------------------------------------------------------
//  [Public] Shared pointer typedef
//------------------------------------------------------------------------------
    typedef boost::shared_ptr<DBManager> SP;

protected:
//------------------------------------------------------------------------------
//  [Protected] Constructor destructor deleter
//------------------------------------------------------------------------------
    DBManager(Tango::DeviceImpl*, Configuration::SP);

    virtual ~DBManager();

    class Deleter;
    friend Deleter;
    class Deleter
    {
        public:
            void operator()(DBManager* d) { delete d; }
    };

public:
//------------------------------------------------------------------------------
//	[Public] Class creation method
//------------------------------------------------------------------------------
    static DBManager::SP create(Tango::DeviceImpl*, Configuration::SP);

//------------------------------------------------------------------------------
//  [Public] Connection management methods
//------------------------------------------------------------------------------
    virtual void connect() throw(soci::soci_error);

    virtual void disconnect();

//------------------------------------------------------------------------------
//  [Public] Retrieve information schema method
//------------------------------------------------------------------------------
    typedef boost::tuple< boost::optional<std::string>, boost::optional<std::string>,
        boost::optional<std::string> > InformationTuple;

    typedef std::vector< InformationTuple > InformationList;

    virtual InformationList retrieveInformation(std::string,
        std::string) throw(soci::soci_error);

//------------------------------------------------------------------------------
//  [Public] Search new tuple method
//------------------------------------------------------------------------------
    typedef std::vector<soci::row> MetadataList;

    virtual MetadataList retrieveNewTuples(std::string, std::string,
        std::tm) throw(soci::soci_error);

protected:
//------------------------------------------------------------------------------
//  [Protected] Class variables
//------------------------------------------------------------------------------
    //Configuration shared pointer
    Configuration::SP m_configuration_sp;

    //Connection pool mutex
    boost::mutex m_connectionPoolMutex;

    //Database connection pool scoped pointer
    boost::scoped_ptr<soci::connection_pool> m_connectionPool_sp;
};

}   //End of namespace

#endif	/* DBMANAGER_H */
