#ifndef PROTOCOLMANAGER_H
#define	PROTOCOLMANAGER_H

#include <Response.pb.h>
#include <Request.pb.h>
#include <Configuration.h>
#include <DBManager.h>

#include <tango.h>

namespace MetadataExporter_ns
{

//Protocol buffer request class shared pointer
typedef boost::shared_ptr<Request> RequestSP;

//Protocol buffer response class shared pointer
typedef boost::shared_ptr<Response> ResponseSP;

class ProtocolManager : public Tango::LogAdapter
{
public:
//------------------------------------------------------------------------------
//  [Public] Shared pointer typedef
//------------------------------------------------------------------------------
    typedef boost::shared_ptr<ProtocolManager> SP;

protected:
//------------------------------------------------------------------------------
//  [Protected] Constructor destructor deleter
//------------------------------------------------------------------------------
    ProtocolManager(Tango::DeviceImpl*, Configuration::SP, DBManager::SP);

    virtual ~ProtocolManager();

    class Deleter;
    friend Deleter;
    class Deleter
    {
        public:
            void operator()(ProtocolManager* d) { delete d; }
    };

public:
//------------------------------------------------------------------------------
//	[Public] Class creation method
//------------------------------------------------------------------------------
    static ProtocolManager::SP create(Tango::DeviceImpl*, Configuration::SP,
        DBManager::SP);

//------------------------------------------------------------------------------
//  [Public] Request response management method
//------------------------------------------------------------------------------
    virtual ResponseSP prepareResponse(RequestSP)
        throw(std::runtime_error);

protected:
//------------------------------------------------------------------------------
//  [Protected] Request specific methods
//------------------------------------------------------------------------------
    virtual ResponseSP prepareAuthroisation(RequestSP)
        throw(std::runtime_error);

    virtual ResponseSP prepareValidation(RequestSP)
        throw(std::runtime_error);

    virtual ResponseSP prepareMetadata(RequestSP)
        throw(std::runtime_error);

//------------------------------------------------------------------------------
//  [Protected] Validation related methods
//------------------------------------------------------------------------------
    virtual void validateColumn(const Request::Validation::Column&,
    DBManager::InformationList&) throw(std::runtime_error);

//------------------------------------------------------------------------------
//  [Protected] Class variables
//------------------------------------------------------------------------------
    //Configuration parameters shared pointer
    Configuration::SP m_configuration_sp;

    //Database manger shared pointer
    DBManager::SP m_dBManager_sp;

    //Client is authorised
    bool m_isAuthorised;

    //Table structure is validated
    bool m_isValidated;
};

}   //End of namespace

#endif	/* PROTOCOLMANAGER_H */

