#ifndef SSLSESSION_H
#define	SSLSESSION_H

#include <Session.h>
#include <Configuration.h>
#include <DBManager.h>

#include <tango.h>

#include <boost/enable_shared_from_this.hpp>
#include <boost/asio/ssl.hpp>

namespace MetadataExporter_ns
{

class SSLSession : public Session,
        public boost::enable_shared_from_this<SSLSession>
{
protected:
//------------------------------------------------------------------------------
//	[Protected] Constructor destructor deleter
//------------------------------------------------------------------------------
    SSLSession(Tango::DeviceImpl*, Configuration::SP, DBManager::SP,
        boost::shared_ptr<boost::asio::io_service>,
        boost::shared_ptr<boost::asio::ssl::context>);

    virtual ~SSLSession();

    class Deleter;
    friend Deleter;
    class Deleter
    {
	public:
		void operator()(SSLSession* d) { delete d; }
    };

public:
//------------------------------------------------------------------------------
//	[Public] Class creation method
//------------------------------------------------------------------------------
    static Session::SP create(Tango::DeviceImpl*, Configuration::SP,
        DBManager::SP, boost::shared_ptr<boost::asio::io_service>,
        boost::shared_ptr<boost::asio::ssl::context>);

//------------------------------------------------------------------------------
//	[Public] Incoming connection methods
//------------------------------------------------------------------------------
    virtual boost::asio::ip::tcp::socket& getSocket();

    virtual void start();

protected:
//------------------------------------------------------------------------------
//  [Protected] Utilities methods
//------------------------------------------------------------------------------
    virtual void startHandShake();

    virtual void handleHandShake(const boost::system::error_code&);

    virtual void startReadRequestHeader();

    virtual void startReadRequestBody(boost::uint32_t);

    virtual void startWriteResponse();

//------------------------------------------------------------------------------
//	[Protected] Class variables
//------------------------------------------------------------------------------
    //SSL socket object
    boost::asio::ssl::stream<boost::asio::ip::tcp::socket> m_sslSocket;
};

}   //End of namespace

#endif	/* SSLSESSION_H */

