/*----- PROTECTED REGION ID(MetadataExporterStateMachine.cpp) ENABLED START -----*/
//=============================================================================
//
// file :        MetadataExporterStateMachine.cpp
//
// description : State machine file for the MetadataExporter class
//
// project :     Metadata exporter device server
//
// This file is part of Tango device class.
// 
// Tango is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// Tango is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public License
// along with Tango.  If not, see <http://www.gnu.org/licenses/>.
// 
// $Author:  $
//
// $Revision:  $
// $Date:  $
//
// $HeadURL:  $
//
//=============================================================================
//                This file is generated by POGO
//        (Program Obviously used to Generate tango Object)
//=============================================================================

#include <MetadataExporter.h>

/*----- PROTECTED REGION END -----*/	//	MetadataExporter::MetadataExporterStateMachine.cpp

//================================================================
//  States  |  Description
//================================================================
//  ON      |  Metadata exporter is in ON state (ready to incoming connections)
//  OFF     |  Metadata exporter is in OFF state (not ready for incoming connections)
//  FAULT   |  Metadata exporter is in FAULT state (an error occurred)


namespace MetadataExporter_ns
{
//=================================================
//		Attributes Allowed Methods
//=================================================

//=================================================
//		Commands Allowed Methods
//=================================================

//--------------------------------------------------------
/**
 *	Method      : MetadataExporter::is_On_allowed()
 *	Description : Execution allowed for On attribute
 */
//--------------------------------------------------------
bool MetadataExporter::is_On_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Compare device state with not allowed states.
	if (get_state()==Tango::ON ||
		get_state()==Tango::FAULT)
	{
	/*----- PROTECTED REGION ID(MetadataExporter::OnStateAllowed) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	MetadataExporter::OnStateAllowed
		return false;
	}
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : MetadataExporter::is_Off_allowed()
 *	Description : Execution allowed for Off attribute
 */
//--------------------------------------------------------
bool MetadataExporter::is_Off_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Compare device state with not allowed states.
	if (get_state()==Tango::OFF ||
		get_state()==Tango::FAULT)
	{
	/*----- PROTECTED REGION ID(MetadataExporter::OffStateAllowed) ENABLED START -----*/
	
	/*----- PROTECTED REGION END -----*/	//	MetadataExporter::OffStateAllowed
		return false;
	}
	return true;
}

}	//	End of namespace
