/*----- PROTECTED REGION ID(MetadataExporter.h) ENABLED START -----*/
//=============================================================================
//
// file :        MetadataExporter.h
//
// description : Include file for the MetadataExporter class
//
// project :     Metadata exporter device server
//
// This file is part of Tango device class.
//
// Tango is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Tango is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with Tango.  If not, see <http://www.gnu.org/licenses/>.
//
// $Author:  $
//
// $Revision:  $
// $Date:  $
//
// $HeadURL:  $
//
//=============================================================================
//                This file is generated by POGO
//        (Program Obviously used to Generate tango Object)
//=============================================================================


#ifndef MetadataExporter_H
#define MetadataExporter_H

#include <Server.h>

#include <tango.h>

#include <map>

/*----- PROTECTED REGION END -----*/	//	MetadataExporter.h

/**
 *  MetadataExporter class description:
 *    Metadata exporter device server
 */

namespace MetadataExporter_ns
{
/*----- PROTECTED REGION ID(MetadataExporter::Additional Class Declarations) ENABLED START -----*/

//	Additional Class Declarations

/*----- PROTECTED REGION END -----*/	//	MetadataExporter::Additional Class Declarations

class MetadataExporter : public TANGO_BASE_CLASS
{

/*----- PROTECTED REGION ID(MetadataExporter::Data Members) ENABLED START -----*/

protected:
//------------------------------------------------------------------------------
//  [Protected] Class variables
//------------------------------------------------------------------------------
    //Configuration class shared pointer
    Configuration::SP m_configuration_sp;

    //Server base class shared pointer
    Server::SP m_server_sp;

    //Max local port number allowed value
    static const unsigned int MAX_LOCAL_PORT = 65535;

    //Max number of worker thread allowed
    static const unsigned int MAX_WORKER_NUMBER = 100;

    //Max number of database connection allowed
    static const unsigned int MAX_DB_CONNECTION_NUMBER = 100;

    //Max database port number allowed value
    static const unsigned int MAX_DB_PORT = 65535;

/*----- PROTECTED REGION END -----*/	//	MetadataExporter::Data Members

//	Device property data members
public:
	//	CertificateFile:	Absolute path to certificate chain file
	string	certificateFile;
	//	PrivateKeyFile:	Absolute path to private key file
	string	privateKeyFile;
	//	DHTempFile:	Absolute path to Diffie Hellman temporary file
	string	dHTempFile;
	//	LocalHost:	Local host address for incoming connection
	string	localHost;
	//	LocalPort:	Local port for wait incoming connection
	Tango::DevULong	localPort;
	//	WorkerNumber:	Number of threads that call io service run methods
	Tango::DevUShort	workerNumber;
	//	EnableSSL:	Enable or disable SSL connections
	Tango::DevBoolean	enableSSL;
	//	DatabaseHost:	Metadata database host
	string	databaseHost;
	//	DatabasePort:	Metadata database port
	Tango::DevULong	databasePort;
	//	DatabaseUsername:	Metadata database login username
	string	databaseUsername;
	//	DatabasePassword:	Metadata database login password
	string	databasePassword;
	//	DatabaseConnectionNumber:	Number of database connection created
	Tango::DevUShort	databaseConnectionNumber;
	//	ExportedTables:	Tables exporter from database: one table per row
	//  [schema table]
	vector<string>	exportedTables;
	//	AuthorisedUsers:	Authorised user list: one user per row
	//  [username password]
	vector<string>	authorisedUsers;


//	Constructors and destructors
public:
	/**
	 * Constructs a newly device object.
	 *
	 *	@param cl	Class.
	 *	@param s 	Device Name
	 */
	MetadataExporter(Tango::DeviceClass *cl,string &s);
	/**
	 * Constructs a newly device object.
	 *
	 *	@param cl	Class.
	 *	@param s 	Device Name
	 */
	MetadataExporter(Tango::DeviceClass *cl,const char *s);
	/**
	 * Constructs a newly device object.
	 *
	 *	@param cl	Class.
	 *	@param s 	Device name
	 *	@param d	Device description.
	 */
	MetadataExporter(Tango::DeviceClass *cl,const char *s,const char *d);
	/**
	 * The device object destructor.
	 */	
	~MetadataExporter() {delete_device();};


//	Miscellaneous methods
public:
	/*
	 *	will be called at device destruction or at init command.
	 */
	void delete_device();
	/*
	 *	Initialize the device
	 */
	virtual void init_device();
	/*
	 *	Read the device properties from database
	 */
	void get_device_property();
	/*
	 *	Always executed method before execution command method.
	 */
	virtual void always_executed_hook();


//	Attribute methods
public:
	//--------------------------------------------------------
	/*
	 *	Method      : MetadataExporter::read_attr_hardware()
	 *	Description : Hardware acquisition for attributes.
	 */
	//--------------------------------------------------------
	virtual void read_attr_hardware(vector<long> &attr_list);


	//--------------------------------------------------------
	/**
	 *	Method      : MetadataExporter::add_dynamic_attributes()
	 *	Description : Add dynamic attributes if any.
	 */
	//--------------------------------------------------------
	void add_dynamic_attributes();



//	Command related methods
public:
	/**
	 *	Command On related method
	 *	Description: Activate metadata exporter
	 *
	 */
	virtual void on();
	virtual bool is_On_allowed(const CORBA::Any &any);
	/**
	 *	Command Off related method
	 *	Description: Deactivate fits importer
	 *
	 */
	virtual void off();
	virtual bool is_Off_allowed(const CORBA::Any &any);


/*----- PROTECTED REGION ID(MetadataExporter::Additional Method prototypes) ENABLED START -----*/

protected:
//------------------------------------------------------------------------------
//  [Protected] Utilities methods
//------------------------------------------------------------------------------
    virtual void importExportedTables(std::vector<std::string>&,
        std::multimap<const std::string, const std::string>&)
        throw(std::invalid_argument);

    virtual void importAuthorisedUsers(std::vector<std::string>&,
        std::map<const std::string, const std::string>&)
        throw(std::invalid_argument);

    virtual void checkIfFileExists(std::string)
        throw(std::invalid_argument);

/*----- PROTECTED REGION END -----*/	//	MetadataExporter::Additional Method prototypes
};

/*----- PROTECTED REGION ID(MetadataExporter::Additional Classes Definitions) ENABLED START -----*/

//	Additional Classes Definitions

/*----- PROTECTED REGION END -----*/	//	MetadataExporter::Additional Classes Definitions

}	//	End of namespace

#endif   //	MetadataExporter_H
