#include <Session.h>

namespace MetadataExporter_ns
{

//==============================================================================
//      Session::Session()
//==============================================================================
Session::Session(Tango::DeviceImpl* deviceImpl_p,  Configuration::SP configuration_sp,
    DBManager::SP dBManager_sp, boost::shared_ptr<boost::asio::io_service> ioService_sp) :
    Tango::LogAdapter(deviceImpl_p), m_configuration_sp(configuration_sp),
    m_strand(*ioService_sp)
{
    DEBUG_STREAM << "Session::Session()" << endl;

    m_protocolManager_sp = ProtocolManager::create(deviceImpl_p,
        configuration_sp, dBManager_sp);
}

//==============================================================================
//      Session::~Session()
//==============================================================================
Session::~Session()
{
    DEBUG_STREAM << "Session::~Session()" << endl;
}

//==============================================================================
//      Session::handleReadRequestHeader()
//==============================================================================
void Session::handleReadRequestHeader(const boost::system::error_code& errorCode)
{
    DEBUG_STREAM << "Session::handleReadRequestHeader()" << endl;

    if(!errorCode)
    {
        boost::uint32_t bodySize = decodeHeader(m_readBuff);

        startReadRequestBody(bodySize);
    }
    else if(errorCode == boost::asio::error::eof)
    {
        DEBUG_STREAM << "Session::handleReadRequestBody() end of file from "
            << m_remoteEndpoint << endl;
    }
    else
    {
        ERROR_STREAM << "Session::handleReadRequestHeader() "
            << errorCode.message() << " from " << m_remoteEndpoint << endl;
    }
}

//==============================================================================
//      Session::handleReadRequestBody()
//==============================================================================
void Session::handleReadRequestBody(const boost::system::error_code& errorCode)
{
    DEBUG_STREAM << "Session::handleReadRequestBody()" << endl;

    if(!errorCode)
    {
        startWriteResponse();
    }
    else if(errorCode == boost::asio::error::eof)
    {
        DEBUG_STREAM << "Session::handleReadRequestBody() end of file from"
            << m_remoteEndpoint << endl;
    }
    else
    {
        ERROR_STREAM << "Session::handleReadRequestBody() "
            << errorCode.message() << " from " << m_remoteEndpoint << endl;
    }
}

//==============================================================================
//      Session::handleWriteResponse()
//==============================================================================
void Session::handleWriteResponse(const boost::system::error_code& errorCode)
{
    DEBUG_STREAM << "Session::handleWriteResponse()" << endl;

    if(!errorCode)
    {
        startReadRequestHeader();
    }
    else if(errorCode == boost::asio::error::eof)
    {
        DEBUG_STREAM << "Session::handleWriteResponse() end of file from "
            << m_remoteEndpoint << endl;
    }
    else
    {
        ERROR_STREAM << "Session::handleWriteResponse() "
            << errorCode.message() << " from " << m_remoteEndpoint << endl;
    }
}

//==============================================================================
//      Session::encodeHeader()
//==============================================================================
void Session::encodeHeader(std::vector<boost::uint8_t>& buf, boost::uint32_t size)
    /*throw(std::runtime_error)*/
{
    DEBUG_STREAM << "Session::encodeHeader()" << endl;

    if(buf.size() < HEADER_SIZE)
        throw std::runtime_error("Buffer to small to contain header!");

    buf[0] = static_cast<boost::uint8_t>((size >> 24) & 0xFF);
    buf[1] = static_cast<boost::uint8_t>((size >> 16) & 0xFF);
    buf[2] = static_cast<boost::uint8_t>((size >> 8) & 0xFF);
    buf[3] = static_cast<boost::uint8_t>(size & 0xFF);
}

//==============================================================================
//      Session::decodeHeader()
//==============================================================================
boost::uint32_t Session::decodeHeader(std::vector<boost::uint8_t>& buf)
    /*throw(std::runtime_error)*/
{
    DEBUG_STREAM << "Session::decodeHeader()" << endl;

    if(buf.size() < HEADER_SIZE)
        throw std::runtime_error("Buffer to small to contain header!");

    boost::uint32_t size = 0;

    for (unsigned i = 0; i < HEADER_SIZE; ++i)
        size = size * 256 + (static_cast<unsigned>(buf[i]) & 0xFF);

    return size;
}

}   //namespace
