#!/bin/bash

#: Title	: checkfits.sh
#: Date		: 2014/10/28
#: Author	: "Marco De Marco" <demarco@oats.inaf.it>
#: Version	: 1.0
#: Description	: Fits verification and preproccessing script


if [ "$1" == "CHECK" ]; then

	#: Section	: CHECK
	#: Parameter	: none
	#: Response	: CHECK OK
	#: 		: CHECK FATAL
	#: Description	: Check availability of script tools

	echo "CHECK OK"
	exit 0

elif [ "$1" == "VALID" ]; then

	#: Section	: VALID
	#: Parameter	: file path
	#: Response	: VALID OK
	#: 		: VALID IGNORE
	#: Description	: Check file name compliance

	echo "VALID OK"
	exit 0

elif [ "$1" == "VERIFY" ]; then

	#: Section	: VERIFY
	#: Parameter	: file path
	#: Response	: VERIFY OK
	#: 		: VERIFY WAIT
	#: 		: VERIFY FATAL
	#: Description	: Check file compliance to fits format

	file=$2

	echo "VERIFY OK"
	exit 0

elif [ "$1" == "PREPROCESS" ]; then

	#: Section	: PREPROCESS
	#: Parameter	: file path
	#: 		: ingestion result [OK, WAIT, FATAL]
	#: Response	: PREPROCESS OK
	#: 		: PREPROCESS FATAL
	#: Description	: Apply preprocessing before ingestion

	file=$2
	verified=$3

	#Check verified parameter value
	if [ "$verified" != "OK" -a "$verified" != "WAIT" -a "$verified" != "FATAL" ]; then
		echo "PREPROCESS FATAL"
		exit 0
	fi

	echo "PREPROCESS OK"
	exit 0

elif [ "$1" == "POSTPROCESS" ]; then

	#: Section	: POSTPROCESS
	#: Parameter	: file path
	#: 		: ingestion result [OK, WAIT, FATAL]
	#: Response	: POSTPROCESS OK
	#: 		: POSTPROCESS FATAL
	#: Description	: Apply postprocessing after ingestion

	file=$2
	verified=$3

	#Check verified parameter value
	if [ "$verified" != "OK" -a "$verified" != "WAIT" -a "$verified" != "FATAL" ]; then
		echo "POSTPROCESS FATAL"
		exit 0
	fi

	#Post process verified WAIT files
	#if [ "$verified" == "WAIT" ]; then

	#fi

	#Post process verified FATAL files
	#if [ "$verified" == "FATAL" ]; then

	#fi

	echo "POSTPROCESS OK"
	exit 0

else

	#: Section	: DEFAULT
	#: Parameter	: none
	#: Response	: UNKNOWN

	echo "UNKNOWN"
	exit 0

fi
