#!/bin/bash

#: Title	: fits.sh
#: Date		: 2014/03/03
#: Author	: "Marco De Marco" <demarco@oats.inaf.it>
#: Version	: 0.1
#: Description	: Fits verification and preproccessing script
#: Usage 	: 
#: Response	: 


if [ "$1" == "CHECK" ]; then

	#: Section	: CHECK
	#: Parameter	: none
	#: Response	: CHECK OK
	#: 		: CHECK FATAL

	VERIFY_TOOL="/usr/local/bin/fitsverify"
	CHECK_STRING="conform to the FITS format"

	res=$($VERIFY_TOOL 2>&1)
	check=$(echo $res | grep "$CHECK_STRING" | wc | awk '{print $1}')
	if [ "$check" -ge "1" ]; then
		echo "CHECK OK"
	else
		echo "CHECK FATAL"
	fi
	exit 0

elif [ "$1" == "VERIFY" ]; then

	#: Section	: VERIFY
	#: Parameter	: file path 
	#: Response	: VERIFY OK
	#: 		: VERIFY WAIT
	#: 		: VERIFY FATAL

	VERIFY_TOOL="/usr/local/bin/fitsverify"
	FATAL_ERROR="Fatal"
	EOF_ERROR="End-of-file"

	file=$2
	file_name=${file##*/}

	#Check regular expression -> fatal
	if [[ ! "${file_name,,}" =~ ^[^\.].*\.(fits|fit|fts).*$ ]]; then
		echo "VERIFY FATAL : error on regular expression"
		exit 0
	fi

	#if fits verify tools exists -> fatal
	if [ ! -x $VERIFY_TOOL ]; then
		echo "VERIFY FATAL : verify tools not exists"
		exit 0
	fi

	#if fits file not exists -> fatal
	if [ ! -f $file ]; then
		echo "VERIFY FATAL : file not exists"
		exit 0
	fi

	#Check with fits verify
	res=$($VERIFY_TOOL $file 2>&1)

	#if fitsverify return fatal error -> wait
	fatal=$(echo $res | grep "$FATAL_ERROR" | wc | awk '{print $1}')
	if [ "$fatal" -ge "1" ]; then
		echo "VERIFY WAIT"
		exit 0
	fi

	#if fitsverify return end of file -> wait
	eof=$(echo $res | grep "$EOF_ERROR" | wc | awk '{print $1}')
	if [ "$eof" -ge "1" ]; then
		echo "VERIFY WAIT"
		exit 0
	fi

	#else -> ok
	echo "VERIFY OK"
	exit 0

elif [ "$1" == "PROCESS" ]; then

	#: Section	: PROCESS 
	#: Parameter	: file path 
	#: Response	: PROCESS OK
	#: 		: PROCESS FATAL

	echo "PROCESS OK"
	exit 0

else

	#: Section	: DEFAULT
	#: Parameter	: none
	#: Response	: UNKNOWN

	echo "UNKNOWN"
	exit 0

fi
