#ifndef EVENT_BUFFER_H
#define EVENT_BUFFER_H

#include <tango.h>

#include <map>
#include <vector>
#include <iostream>
#include <stdexcept>

#include <boost/shared_ptr.hpp>
#include <boost/thread/mutex.hpp>
#include <boost/thread/condition_variable.hpp>
#include <boost/filesystem.hpp>

namespace PreProcessor_ns
{

class EventBuffer : public Tango::LogAdapter
{
public:
//------------------------------------------------------------------------------
//	[Public] Shared pointer typedef
//------------------------------------------------------------------------------
	typedef boost::shared_ptr<EventBuffer> SP;

protected:
//------------------------------------------------------------------------------
//	[Protected] Constructor destructor deleter
//------------------------------------------------------------------------------
	EventBuffer(Tango::DeviceImpl*);

	virtual ~EventBuffer();

	class Deleter;
	friend class Deleter;
	class Deleter
	{
	public:
		void operator()(EventBuffer* e) { delete e; }
	};

public:
//------------------------------------------------------------------------------
//	[Public] Users methods
//------------------------------------------------------------------------------
	static EventBuffer::SP create(Tango::DeviceImpl*);

	virtual void insertNew(boost::filesystem::path);

	virtual boost::filesystem::path waitNew();

    virtual void markAsProcessed(boost::filesystem::path);

    virtual void removeAllProcessed();

	virtual std::size_t size();

protected:
//------------------------------------------------------------------------------
//	[Protected] Event status enumeration
//------------------------------------------------------------------------------
    enum EventStatus { UNPROCESSED=0, ASSIGNED=1, PROCESSED=2 };

//------------------------------------------------------------------------------
//	[Protected] Class variables
//------------------------------------------------------------------------------
	//Access synchronization mutex
	boost::mutex m_mutex;

	//Access synchronization condition variable
	boost::condition_variable m_conditionVariable;

	//File buffer
	std::map<boost::filesystem::path, EventStatus> m_buffer;
};

}   //End of namespace

#endif /*!EVENT_BUFFER_H*/
