#ifndef SCRIPT_MANAGER_H
#define SCRIPT_MANAGER_H

#include <Configuration.h>

#include <string>
#include <stdexcept>

#include <tango.h>

#include <boost/shared_ptr.hpp>
#include <boost/filesystem.hpp>

namespace PreProcessor_ns
{

class ScriptManager : public Tango::LogAdapter
{
public:
//------------------------------------------------------------------------------
//	[Public] Shared pointer typedef
//------------------------------------------------------------------------------
	typedef boost::shared_ptr<ScriptManager> SP;

protected:
//------------------------------------------------------------------------------
//	[Protected] Constructor destructor deleter
//------------------------------------------------------------------------------
	ScriptManager(Tango::DeviceImpl* deviceImpl_p, Configuration::SP);

	virtual ~ScriptManager();

	class Deleter;
	friend class Deleter;
	class Deleter
	{
	public:
		void operator()(ScriptManager* f) { delete f; }
	};

public:
//------------------------------------------------------------------------------
//	[Public] Class creation method
//------------------------------------------------------------------------------
	static ScriptManager::SP create(Tango::DeviceImpl*, Configuration::SP);

//------------------------------------------------------------------------------
//  [Public] Script methods
//------------------------------------------------------------------------------
    virtual void checkScriptCompliance()
        throw(std::runtime_error);

	virtual bool isFileVerified(boost::filesystem::path&)
        throw(std::runtime_error);

    virtual void preProcessFile(boost::filesystem::path&)
        throw(std::runtime_error);

protected:
//------------------------------------------------------------------------------
//	[Protected] Utilities methods
//------------------------------------------------------------------------------
    virtual std::string exec(std::string) throw(std::runtime_error);

//------------------------------------------------------------------------------
//	[Protected] Class variables
//------------------------------------------------------------------------------
	//Configuration shared pointer
	Configuration::SP m_configuration_sp;
};

}

#endif /* SCRIPT_MANAGER_H */
