#ifndef CONFIGURATION_H
#define CONFIGURATION_H

#include <iostream>
#include <stdint.h>
#include <vector>
#include <boost/shared_ptr.hpp>

namespace PreProcessor_ns
{

class Configuration
{
public:
//------------------------------------------------------------------------------
//	[Public] Shared pointer typedef
//------------------------------------------------------------------------------
	typedef boost::shared_ptr<Configuration> SP;

private:
//------------------------------------------------------------------------------
//	[Private] Constructor destructor deleter
//------------------------------------------------------------------------------
	Configuration(std::string watchPath, std::string regularPath,
		std::string warningPath, std::string errorPath, std::string scriptPath,
		int workerNumber, int sleepTime, int waitTime, uint32_t iNotifyMask) :
		m_watchPath(watchPath), m_regularPath(regularPath),
        m_warningPath(warningPath), m_errorPath(errorPath),
        m_scriptPath(scriptPath), m_workerNumber(workerNumber),
        m_sleepTime(sleepTime), m_waitTime(waitTime),
        m_iNotifyMask(iNotifyMask) { }

	virtual ~Configuration() {}

	class Deleter;
	friend class Deleter;
	class Deleter
	{
	public:
		void operator()(Configuration* c) { delete c; }
	};

public:
//------------------------------------------------------------------------------
//	[Public] User methods
//------------------------------------------------------------------------------
	static Configuration::SP create(std::string watchPath,
		std::string regularPath, std::string warningPath, std::string errorPath,
        std::string scriptPath, int workerNumber, int sleepTime, int waitTime,
        uint32_t iNotifyMask)
	{
		Configuration::SP c_sp(new Configuration(watchPath, regularPath,
			warningPath, errorPath, scriptPath, workerNumber, sleepTime,
			waitTime, iNotifyMask), Configuration::Deleter());

		return c_sp;
	}

	std::string getWatchPath() const { return m_watchPath; }
	std::string getRegularPath() const { return m_regularPath; }
	std::string getWarningPath() const { return m_warningPath; }
	std::string getErrorPath() const { return m_errorPath; }
    std::string getScriptPath() const { return m_scriptPath; }
	unsigned int getWorkerNumber() const { return m_workerNumber; }
    unsigned int getSleepTime() const { return m_sleepTime; }
	unsigned int getWaitTime() const { return m_waitTime; }
	uint32_t getINotifyMask() const { return m_iNotifyMask; }

private:
//------------------------------------------------------------------------------
//	[Private] class variables
//------------------------------------------------------------------------------
	//INotify watch path
	const std::string m_watchPath;

    //Regular file destination path
    const std::string m_regularPath;

	//Warning file destination path
	const std::string m_warningPath;

	//Error file destination path
	const std::string m_errorPath;

    //Script path file
    const std::string m_scriptPath;

	//Worker thread number
	const unsigned int m_workerNumber;

	//Event thread sleep time
	const unsigned int m_sleepTime;

	//Worker thread wait time
	const unsigned int m_waitTime;

	//INotify mask
	const uint32_t m_iNotifyMask;
};

}   //End of namespace

#endif /*!CONFIGURATION_H*/
