/*----- PROTECTED REGION ID(PreProcessorStateMachine.cpp) ENABLED START -----*/
//=============================================================================
//
// file :        PreProcessorStateMachine.cpp
//
// description : State machine file for the PreProcessor class
//
// project :     PreProcessor
//
// This file is part of Tango device class.
//
// Tango is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Tango is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Tango.  If not, see <http://www.gnu.org/licenses/>.
//
// $Author:  $
//
// $Revision:  $
// $Date:  $
//
// $HeadURL:  $
//
//=============================================================================
//                This file is generated by POGO
//        (Program Obviously used to Generate tango Object)
//=============================================================================

#include <PreProcessor.h>

/*----- PROTECTED REGION END -----*/	//	PreProcessor::PreProcessorStateMachine.cpp

//================================================================
//  States  |  Description
//================================================================
//  ON      |  
//  OFF     |  
//  FAULT   |  Pre processor is in FAULT state (not ready to process data)
//  ALARM   |  Pre processor is in ALARM state (not ready to process data)


namespace PreProcessor_ns
{
//=================================================
//		Attributes Allowed Methods
//=================================================

//--------------------------------------------------------
/**
 *	Method      : PreProcessor::is_IgnoredFileCounter_allowed()
 *	Description : Execution allowed for IgnoredFileCounter attribute
 */
//--------------------------------------------------------
bool PreProcessor::is_IgnoredFileCounter_allowed(TANGO_UNUSED(Tango::AttReqType type))
{

	//	Not any excluded states for IgnoredFileCounter attribute in read access.
	/*----- PROTECTED REGION ID(PreProcessor::IgnoredFileCounterStateAllowed_READ) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	PreProcessor::IgnoredFileCounterStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : PreProcessor::is_RegularFileCounter_allowed()
 *	Description : Execution allowed for RegularFileCounter attribute
 */
//--------------------------------------------------------
bool PreProcessor::is_RegularFileCounter_allowed(TANGO_UNUSED(Tango::AttReqType type))
{

	//	Not any excluded states for RegularFileCounter attribute in read access.
	/*----- PROTECTED REGION ID(PreProcessor::RegularFileCounterStateAllowed_READ) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	PreProcessor::RegularFileCounterStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : PreProcessor::is_WarningFileCounter_allowed()
 *	Description : Execution allowed for WarningFileCounter attribute
 */
//--------------------------------------------------------
bool PreProcessor::is_WarningFileCounter_allowed(TANGO_UNUSED(Tango::AttReqType type))
{

	//	Not any excluded states for WarningFileCounter attribute in read access.
	/*----- PROTECTED REGION ID(PreProcessor::WarningFileCounterStateAllowed_READ) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	PreProcessor::WarningFileCounterStateAllowed_READ
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : PreProcessor::is_ErrorFileCounter_allowed()
 *	Description : Execution allowed for ErrorFileCounter attribute
 */
//--------------------------------------------------------
bool PreProcessor::is_ErrorFileCounter_allowed(TANGO_UNUSED(Tango::AttReqType type))
{

	//	Not any excluded states for ErrorFileCounter attribute in read access.
	/*----- PROTECTED REGION ID(PreProcessor::ErrorFileCounterStateAllowed_READ) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	PreProcessor::ErrorFileCounterStateAllowed_READ
	return true;
}

//=================================================
//		Commands Allowed Methods
//=================================================

//--------------------------------------------------------
/**
 *	Method      : PreProcessor::is_On_allowed()
 *	Description : Execution allowed for On attribute
 */
//--------------------------------------------------------
bool PreProcessor::is_On_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Compare device state with not allowed states.
	if (get_state()==Tango::ON ||
		get_state()==Tango::FAULT ||
		get_state()==Tango::ALARM)
	{
	/*----- PROTECTED REGION ID(PreProcessor::OnStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	PreProcessor::OnStateAllowed
		return false;
	}
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : PreProcessor::is_Off_allowed()
 *	Description : Execution allowed for Off attribute
 */
//--------------------------------------------------------
bool PreProcessor::is_Off_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Compare device state with not allowed states.
	if (get_state()==Tango::OFF ||
		get_state()==Tango::FAULT ||
		get_state()==Tango::ALARM)
	{
	/*----- PROTECTED REGION ID(PreProcessor::OffStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	PreProcessor::OffStateAllowed
		return false;
	}
	return true;
}

//--------------------------------------------------------
/**
 *	Method      : PreProcessor::is_ResetCounter_allowed()
 *	Description : Execution allowed for ResetCounter attribute
 */
//--------------------------------------------------------
bool PreProcessor::is_ResetCounter_allowed(TANGO_UNUSED(const CORBA::Any &any))
{
	//	Not any excluded states for ResetCounter command.
	/*----- PROTECTED REGION ID(PreProcessor::ResetCounterStateAllowed) ENABLED START -----*/

	/*----- PROTECTED REGION END -----*/	//	PreProcessor::ResetCounterStateAllowed
	return true;
}

}	//	End of namespace
