/*----- PROTECTED REGION ID(PreProcessor.h) ENABLED START -----*/
//=============================================================================
//
// file :        PreProcessor.h
//
// description : Include file for the PreProcessor class
//
// project :     PreProcessor
//
// This file is part of Tango device class.
//
// Tango is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Tango is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Tango.  If not, see <http://www.gnu.org/licenses/>.
//
// $Author:  $
//
// $Revision:  $
// $Date:  $
//
// $HeadURL:  $
//
//=============================================================================
//                This file is generated by POGO
//        (Program Obviously used to Generate tango Object)
//=============================================================================


#ifndef PreProcessor_H
#define PreProcessor_H

#include <Configuration.h>
#include <EventThread.h>

#include <tango.h>


/*----- PROTECTED REGION END -----*/	//	PreProcessor.h

/**
 *  PreProcessor class description:
 *    Pre proccesing generic server
 */

namespace PreProcessor_ns
{
/*----- PROTECTED REGION ID(PreProcessor::Additional Class Declarations) ENABLED START -----*/

//	Additional Class Declarations

/*----- PROTECTED REGION END -----*/	//	PreProcessor::Additional Class Declarations

class PreProcessor : public TANGO_BASE_CLASS
{

/*----- PROTECTED REGION ID(PreProcessor::Data Members) ENABLED START -----*/

//------------------------------------------------------------------------------
//  [Private] Class variables
//------------------------------------------------------------------------------
    //Configuration shared pointer
    Configuration::SP m_configuration_sp;

    //Thread shared pointer
    EventThread::SP m_eventThread_sp;

    //Min milli second of sleep time allowed
    static const unsigned long MIN_SLEEP_TIME = 100;

    //Max milli second of sleep time allowed
    static const unsigned long MAX_SLEEP_TIME = 10000;

    //Max milli second of wait time allowed
    static const unsigned long MAX_WAIT_TIME = 10000;

    //Max number of worker thread allowed
    static const unsigned int MAX_WORKER_NUMBER = 100;

/*----- PROTECTED REGION END -----*/	//	PreProcessor::Data Members

//	Device property data members
public:
	//	WatchPath:
	string	watchPath;
	//	DestPath:
	string	destPath;
	//	ScriptPath:
	string	scriptPath;
	//	EventList:
	vector<string>	eventList;
	//	SleepTime:
	Tango::DevULong	sleepTime;
	//	WaitTime:
	Tango::DevUShort	waitTime;
	//	WorkerNumber:
	Tango::DevUShort	workerNumber;


//	Constructors and destructors
public:
	/**
	 * Constructs a newly device object.
	 *
	 *	@param cl	Class.
	 *	@param s 	Device Name
	 */
	PreProcessor(Tango::DeviceClass *cl,string &s);
	/**
	 * Constructs a newly device object.
	 *
	 *	@param cl	Class.
	 *	@param s 	Device Name
	 */
	PreProcessor(Tango::DeviceClass *cl,const char *s);
	/**
	 * Constructs a newly device object.
	 *
	 *	@param cl	Class.
	 *	@param s 	Device name
	 *	@param d	Device description.
	 */
	PreProcessor(Tango::DeviceClass *cl,const char *s,const char *d);
	/**
	 * The device object destructor.
	 */
	~PreProcessor() {delete_device();};


//	Miscellaneous methods
public:
	/*
	 *	will be called at device destruction or at init command.
	 */
	void delete_device();
	/*
	 *	Initialize the device
	 */
	virtual void init_device();
	/*
	 *	Read the device properties from database
	 */
	void get_device_property();
	/*
	 *	Always executed method before execution command method.
	 */
	virtual void always_executed_hook();


//	Attribute methods
public:
	//--------------------------------------------------------
	/*
	 *	Method      : PreProcessor::read_attr_hardware()
	 *	Description : Hardware acquisition for attributes.
	 */
	//--------------------------------------------------------
	virtual void read_attr_hardware(vector<long> &attr_list);


	//--------------------------------------------------------
	/**
	 *	Method      : PreProcessor::add_dynamic_attributes()
	 *	Description : Add dynamic attributes if any.
	 */
	//--------------------------------------------------------
	void add_dynamic_attributes();



//	Command related methods
public:
	/**
	 *	Command On related method
	 *	Description:
	 *
	 */
	virtual void on();
	virtual bool is_On_allowed(const CORBA::Any &any);
	/**
	 *	Command Off related method
	 *	Description:
	 *
	 */
	virtual void off();
	virtual bool is_Off_allowed(const CORBA::Any &any);


/*----- PROTECTED REGION ID(PreProcessor::Additional Method prototypes) ENABLED START -----*/

private:
//------------------------------------------------------------------------------
//  [Private] Utilities methods
//------------------------------------------------------------------------------
    uint32_t create_inotify_mask(const std::vector<std::string>&)
        throw (std::invalid_argument);

    virtual void checkIfFileExists(std::string)
        throw(std::invalid_argument);

    virtual void checkIfDirectoryExists(std::string)
        throw(std::invalid_argument);

/*----- PROTECTED REGION END -----*/	//	PreProcessor::Additional Method prototypes
};

/*----- PROTECTED REGION ID(PreProcessor::Additional Classes Definitions) ENABLED START -----*/

//	Additional Classes Definitions

/*----- PROTECTED REGION END -----*/	//	PreProcessor::Additional Classes Definitions

}	//	End of namespace

#endif   //	PreProcessor_H
