#ifndef WORKER_THREAD_H
#define WORKER_THREAD_H

#include <Configuration.h>
#include <EventBuffer.h>

#include <tango.h>

#include <stdexcept>
#include <sstream>

#include <boost/shared_ptr.hpp>

namespace PreProcessor_ns
{

class WorkerThread : public Tango::LogAdapter
{
public:
//------------------------------------------------------------------------------
//	[Public] Constructor destructor
//------------------------------------------------------------------------------
	WorkerThread(Tango::DeviceImpl*, EventBuffer::SP);

	virtual ~WorkerThread();

//------------------------------------------------------------------------------
//	[Public] Users method
//------------------------------------------------------------------------------
	virtual void workerLoop();

protected:
//------------------------------------------------------------------------------
//	[Protected] Utilities methods
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
//	[Protected] Class variables
//------------------------------------------------------------------------------
	//Event buffer shared pointer
	EventBuffer::SP m_eventBuffer_sp;

	//Configuration shared pointer
	Configuration::SP m_configuration_sp;
};

}   //End of namespace

#endif /*!WORKER_THREAD_H*/
