#include <WorkerThread.h>
#include <PreProcessor.h>

#include <cassert>
#include <fstream>

#include <tango.h>

#include <boost/scoped_ptr.hpp>
#include <boost/iostreams/filtering_streambuf.hpp>
#include <boost/iostreams/copy.hpp>
#include <boost/iostreams/filter/gzip.hpp>
#include <boost/regex.hpp>
#include <boost/lexical_cast.hpp>

namespace PreProcessor_ns
{

//==============================================================================
//	WorkerThread::WorkerThread()
//==============================================================================
WorkerThread::WorkerThread(PreProcessor* preProcessor_p,
    EventBuffer::SP eventBuffer_sp, Configuration::SP configuration_sp) :
    Tango::LogAdapter(preProcessor_p), m_preProcessor_p(preProcessor_p),
    m_eventBuffer_sp(eventBuffer_sp), m_configuration_sp(configuration_sp)
{
	DEBUG_STREAM << "WorkerThread::WorkerThread()" << std::endl;
}

//==============================================================================
//	WorkerThread::~WorkerThread()
//==============================================================================
WorkerThread::~WorkerThread()
{
	DEBUG_STREAM << "WorkerThread::~WorkerThread()" << std::endl;
}

//==============================================================================
//	WorkerThread::workerLoop()()
//==============================================================================
void WorkerThread::workerLoop()
{
    DEBUG_STREAM << "WorkerThread::workerLoop(): starting loop" << endl;

//	unsigned int waitTime = m_configuration_sp->getWaitTime();
//	std::string watchPath = m_configuration_sp->getWatchPath();

//    while(true)
//    {
//        try
//        {
//            //Wait new file event to process
//            boost::filesystem::path origPath(m_eventBuffer_sp->waitNew());
//            std::string fileName = origPath.stem().string();
//
//            //If configured wait after new file event
//            boost::posix_time::milliseconds waitPosixTime(waitTime);
//            boost::this_thread::sleep( waitPosixTime );
//
//            bool completed = false;
//
//            INFO_STREAM << "WorkerThread::workerLoop() processing \""
//                << fileName << "\"" << endl;
//
//            try
//            {
//                //Open fits file
//                boost::shared_ptr<CCfits::FITS> fitsFile_sp(
//                    new CCfits::FITS(origPath.string(), CCfits::Write));
//
//                //Read all key in primary HDU
//                CCfits::PHDU& phdu = fitsFile_sp->pHDU();
//                phdu.readAllKeys();
//
//                try
//                {
//                    //Try to ingest using an instrument in list
//                    ingestUsingInstrumentList(origPath, fitsFile_sp);
//
//                    completed = true;
//                    m_fitsImporter_p->incrementRegularCounter();
//                    INFO_STREAM << "WorkerThread::workerLoop() \"" << fileName
//                        << "\" archived regularly" << endl;
//                }
//                catch(CCfits::FitsException& ex)
//                {
//                    ERROR_STREAM << "WorkerThread::workerLoop() " << ex.message() << endl;
//                }
//                catch(std::runtime_error& ex)
//                {
//                    ERROR_STREAM << "WorkerThread::workerLoop() " << ex.what() << endl;
//                }
//
//                if(!completed)
//                {
//                    //Try to ingest using default instrument
//                    ingestUsingDefaultInstrument(origPath, fitsFile_sp);
//
//                    completed = true;
//                    m_fitsImporter_p->incrementWarningCounter();
//                    WARN_STREAM << "WorkerThread::workerLoop() \"" << fileName
//                        << "\" archived in default instrument" << endl;
//                }
//            }
//            catch(CCfits::FitsException& ex)
//            {
//                ERROR_STREAM << "WorkerThread::workerLoop() " << ex.message() << endl;
//            }
//            catch(std::runtime_error& ex)
//            {
//                ERROR_STREAM << "WorkerThread::workerLoop() " << ex.what() << endl;
//            }
//
//            if(!completed)
//            {
//                //Cannot ingest new file => notify error
//                m_fitsImporter_p->incrementErrorCounter();
//                ERROR_STREAM << "WorkerThread::workerLoop() \"" << fileName
//                    << "\" not archived" << endl;
//            }
//
//            m_eventBuffer_sp->markAsProcessed(origPath);
//        }
//		catch(boost::thread_interrupted& ex)
//		{
//            DEBUG_STREAM << "WorkerThread::workerLoop() interrupt" << endl;
//
//			break;
//		}
//        catch(std::exception& ex)
//        {
//            ERROR_STREAM << "WorkerThread::workerLoop() " << ex.what() << endl;
//        }
//		catch(...)
//		{
//            ERROR_STREAM << "WorkerThread::workerLoop() unknown exception" << endl;
//		}
//    } //while
}

}   //namespace
