#ifndef WORKER_THREAD_H
#define WORKER_THREAD_H

#include <Configuration.h>
#include <EventBuffer.h>
#include <ScriptManager.h>

#include <tango.h>

#include <boost/shared_ptr.hpp>
#include <boost/filesystem.hpp>

namespace PreProcessor_ns
{

class PreProcessor;

class WorkerThread : public Tango::LogAdapter
{
public:
//------------------------------------------------------------------------------
//	[Public] Constructor destructor
//------------------------------------------------------------------------------
	WorkerThread(PreProcessor*, EventBuffer::SP,
        ScriptManager::SP, Configuration::SP);

	virtual ~WorkerThread();

//------------------------------------------------------------------------------
//	[Public] Users method
//------------------------------------------------------------------------------
	virtual void workerLoop();

protected:
//------------------------------------------------------------------------------
//	[Protected] Utilities methods
//------------------------------------------------------------------------------
	virtual void copyToDestination(boost::filesystem::path&,
		ScriptManager::Verified) throw (std::runtime_error);

//------------------------------------------------------------------------------
//	[Protected] Class variables
//------------------------------------------------------------------------------
    //Tango server class pointer
    PreProcessor* m_preProcessor_p;

	//Event buffer shared pointer
	EventBuffer::SP m_eventBuffer_sp;

	//File manager shared pointer
	ScriptManager::SP m_fileManager_sp;

	//Configuration shared pointer
	Configuration::SP m_configuration_sp;
};

}   //End of namespace

#endif /*!WORKER_THREAD_H*/
