<?php

namespace RAP;

class LoginHandler {

    protected $locator;
    private $identityType;

    public function __construct(Locator $locator, string $identityType) {
        $this->locator = $locator;
        $this->identityType = $identityType;
    }

    public function onIdentityDataReceived(string $typedId, \Closure $fillIdentityData): string {

        $user = $this->locator->getUserHandler()->findUserByIdentity($this->identityType, $typedId);

        if ($user === null) {
            return $this->handleNewUser($typedId, $fillIdentityData);
        }

        return $this->getAfterLoginRedirect($user);
    }

    protected function handleNewUser(string $typedId, \Closure $fillIdentityData): string {

        $session = $this->locator->getSession();

        // Create new user
        $user = new \RAP\User();

        $identity = new Identity($this->identityType);
        $identity->typedId = $typedId;
        $fillIdentityData($identity);

        $user->addIdentity($identity);

        $session->setUser($user);

        // Redirect to Term of Use acceptance page
        return $this->locator->getBasePath() . '/tou-check';
    }

    public function getAfterLoginRedirect(User $user): string {

        $session = $this->locator->getSession();
        $this->locator->getAuditLogger()->info("LOGIN," . $this->identityType . "," . $user->id);

        if ($session->getOAuth2Data() !== null) {
            $session->setUser($user);
            $redirectUrl = $this->locator->getOAuth2RequestHandler()->getCodeResponseUrl();
            session_destroy();
            return $redirectUrl;
        }

        if ($session->getAction() !== null) {
            $session->setUser($user);
            $action = $session->getAction();
            if ($action === 'account' || $action === 'join' || $action === 'admin') {
                return $this->locator->getBasePath() . '/' . $action;
            }
        }

        throw new \Exception("Unable to find a proper redirect");
    }

}
